/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.authz.permission.WildcardPermission;

public class ResourcePermission
extends WildcardPermission {
    public static String ALL = "*";
    public static String NULL = "NULL";
    public static String ALL_REGIONS = "*";
    public static String ALL_KEYS = "*";
    private String resource = NULL;
    private String operation = NULL;
    private String target = ALL;
    private String key = ALL;

    public ResourcePermission() {
        this.setParts(this.resource + ":" + this.operation + ":" + this.target + ":" + this.key, true);
    }

    public ResourcePermission(Resource resource, Operation operation) {
        this(resource, operation, ALL, ALL);
    }

    public ResourcePermission(Resource resource, Operation operation, String target) {
        this(resource, operation, target, ALL);
    }

    public ResourcePermission(Resource resource, Operation operation, Target target) {
        this(resource, operation, target, ALL);
    }

    public ResourcePermission(Resource resource, Operation operation, Target target, String key) {
        this(resource == null ? null : resource.getName(), operation == null ? null : operation.getName(), target == null ? null : target.getName(), key);
    }

    public ResourcePermission(Resource resource, Operation operation, String target, String key) {
        this(resource == null ? null : resource.getName(), operation == null ? null : operation.getName(), target, key);
    }

    public ResourcePermission(String resource, String operation) {
        this(resource, operation, ALL, ALL);
    }

    public ResourcePermission(String resource, String operation, String target) {
        this(resource, operation, target, ALL);
    }

    public ResourcePermission(String resource, String operation, String target, String key) {
        this.resource = this.parsePart(resource, r -> Resource.valueOf(r).getName());
        this.operation = this.parsePart(operation, o -> Operation.valueOf(o).getName());
        if (target != null) {
            this.target = StringUtils.stripStart((String)target, (String)"/");
        }
        if (key != null) {
            this.key = key;
        }
        this.setParts(this.resource + ":" + this.operation + ":" + this.target + ":" + this.key, true);
    }

    private String parsePart(String part, UnaryOperator<String> operator) {
        if (part == null) {
            return NULL;
        }
        if (part.equals(ALL)) {
            return ALL;
        }
        return (String)operator.apply(part.toUpperCase());
    }

    public Resource getResource() {
        if (ALL.equals(this.resource)) {
            return Resource.ALL;
        }
        return Resource.valueOf(this.resource);
    }

    public Operation getOperation() {
        if (ALL.equals(this.operation)) {
            return Operation.ALL;
        }
        return Operation.valueOf(this.operation);
    }

    public String getResourceString() {
        return this.resource;
    }

    public String getOperationString() {
        return this.operation;
    }

    public String getTarget() {
        return this.target;
    }

    public String getRegionName() {
        return this.getTarget();
    }

    public String getKey() {
        return this.key;
    }

    public String toString() {
        ArrayList<String> parts = new ArrayList<String>(Arrays.asList(this.resource, this.operation, this.target, this.key));
        if (ALL.equals(this.key)) {
            parts.remove(3);
            if (ALL.equals(this.target)) {
                parts.remove(2);
                if (ALL.equals(this.operation)) {
                    parts.remove(1);
                }
            }
        }
        return parts.stream().collect(Collectors.joining(":"));
    }

    public static enum Target {
        ALL,
        DISK,
        GATEWAY,
        QUERY,
        DEPLOY;


        public String getName() {
            if (this == ALL) {
                return ALL;
            }
            return this.name();
        }
    }

    public static enum Operation {
        ALL,
        NULL,
        MANAGE,
        WRITE,
        READ;


        public String getName() {
            if (this == ALL) {
                return ALL;
            }
            return this.name();
        }
    }

    public static enum Resource {
        ALL,
        NULL,
        CLUSTER,
        DATA;


        public String getName() {
            if (this == ALL) {
                return ALL;
            }
            return this.name();
        }
    }
}

