/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.string;

import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.RedisDataType;
import org.apache.geode.redis.internal.RedisDataTypeMismatchException;
import org.apache.geode.redis.internal.executor.AbstractExecutor;

public abstract class StringExecutor
extends AbstractExecutor {
    protected void checkAndSetDataType(ByteArrayWrapper key, ExecutionHandlerContext context) {
        RedisDataType oldVal = context.getRegionProvider().metaPutIfAbsent(key, RedisDataType.REDIS_STRING);
        if (oldVal == RedisDataType.REDIS_PROTECTED) {
            throw new RedisDataTypeMismatchException("The key name \"" + key + "\" is protected");
        }
        if (oldVal != null && oldVal != RedisDataType.REDIS_STRING) {
            throw new RedisDataTypeMismatchException("The key name \"" + key + "\" is already used by a " + ((Object)((Object)oldVal)).toString());
        }
    }

    protected void checkDataType(ByteArrayWrapper key, ExecutionHandlerContext context) {
        RedisDataType currentType = context.getRegionProvider().getRedisDataType(key);
        if (currentType == null) {
            return;
        }
        if (currentType == RedisDataType.REDIS_PROTECTED) {
            throw new RedisDataTypeMismatchException("The key name \"" + key + "\" is protected");
        }
        if (currentType != RedisDataType.REDIS_STRING) {
            throw new RedisDataTypeMismatchException("The key name \"" + key + "\" is already used by a " + currentType.toString());
        }
    }
}

