/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.sortedset;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.query.Query;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.Struct;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.DoubleWrapper;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.RedisDataType;
import org.apache.geode.redis.internal.executor.SortedSetQuery;
import org.apache.geode.redis.internal.executor.sortedset.SortedSetExecutor;

public class ZRemRangeByScoreExecutor
extends SortedSetExecutor {
    private final String ERROR_NOT_NUMERIC = "The number provided is not numeric";
    private final int NOT_EXISTS = 0;

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        double stop;
        double start;
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 4) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the ZREMRANGEBYSCORE command is \"ZREMRANGEBYSCORE key min max\""));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        this.checkDataType(key, RedisDataType.REDIS_SORTEDSET, context);
        Region<ByteArrayWrapper, DoubleWrapper> keyRegion = this.getRegion(context, key);
        if (keyRegion == null) {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 0));
            return;
        }
        boolean startInclusive = true;
        boolean stopInclusive = true;
        byte[] startArray = commandElems.get(2);
        byte[] stopArray = commandElems.get(3);
        String startString = Coder.bytesToString(startArray);
        String stopString = Coder.bytesToString(stopArray);
        if (startArray[0] == 40) {
            startString = startString.substring(1);
            startInclusive = false;
        }
        if (stopArray[0] == 40) {
            stopString = stopString.substring(1);
            stopInclusive = false;
        }
        try {
            start = Coder.stringToDouble(startString);
            stop = Coder.stringToDouble(stopString);
        }
        catch (NumberFormatException e) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The number provided is not numeric"));
            return;
        }
        int numRemoved = 0;
        Collection<?> removeList = null;
        try {
            if (start == Double.NEGATIVE_INFINITY && stop == Double.POSITIVE_INFINITY && startInclusive && stopInclusive) {
                numRemoved = keyRegion.size();
                context.getRegionProvider().removeKey(key);
            } else {
                removeList = this.getKeys(context, key, keyRegion, start, stop, startInclusive, stopInclusive);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (removeList != null) {
            for (Object entry : removeList) {
                ByteArrayWrapper remove = null;
                if (entry instanceof Map.Entry) {
                    remove = (ByteArrayWrapper)((Map.Entry)entry).getKey();
                } else if (entry instanceof Struct) {
                    remove = (ByteArrayWrapper)((Struct)entry).getFieldValues()[0];
                }
                DoubleWrapper oldVal = keyRegion.remove(remove);
                if (oldVal != null) {
                    ++numRemoved;
                }
                if (!keyRegion.isEmpty()) continue;
                context.getRegionProvider().removeKey(key);
            }
        }
        command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), numRemoved));
    }

    private Collection<?> getKeys(ExecutionHandlerContext context, ByteArrayWrapper key, Region<ByteArrayWrapper, DoubleWrapper> keyRegion, double start, double stop, boolean startInclusive, boolean stopInclusive) throws Exception {
        if (start == Double.POSITIVE_INFINITY || stop == Double.NEGATIVE_INFINITY || start > stop) {
            return null;
        }
        Query query = startInclusive ? (stopInclusive ? this.getQuery(key, SortedSetQuery.ZRBSSTISI, context) : this.getQuery(key, SortedSetQuery.ZRBSSTI, context)) : (stopInclusive ? this.getQuery(key, SortedSetQuery.ZRBSSI, context) : this.getQuery(key, SortedSetQuery.ZRBS, context));
        Object[] params = new Object[]{start, stop, INFINITY_LIMIT};
        SelectResults results = (SelectResults)query.execute(params);
        return results.asList();
    }
}

