/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.sortedset;

import java.util.List;
import org.apache.geode.cache.Region;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.DoubleWrapper;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.RedisDataType;
import org.apache.geode.redis.internal.executor.sortedset.SortedSetExecutor;

public class ZIncrByExecutor
extends SortedSetExecutor {
    private final String ERROR_NOT_NUMERIC = "The number provided is not numeric";
    private final String ERROR_NAN = "This increment is illegal because it would result in a NaN";

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        double incr;
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() != 4) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the ZINCRBY command is \"ZINCRBY key increment member\""));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        Region<ByteArrayWrapper, DoubleWrapper> keyRegion = this.getOrCreateRegion(context, key, RedisDataType.REDIS_SORTEDSET);
        ByteArrayWrapper member = new ByteArrayWrapper(commandElems.get(3));
        try {
            byte[] incrArray = commandElems.get(2);
            incr = Coder.bytesToDouble(incrArray);
        }
        catch (NumberFormatException e) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The number provided is not numeric"));
            return;
        }
        DoubleWrapper score = keyRegion.get(member);
        if (score == null) {
            keyRegion.put(member, new DoubleWrapper(incr));
            command.setResponse(Coder.getBulkStringResponse(context.getByteBufAllocator(), incr));
            return;
        }
        double result = score.score + incr;
        if (Double.isNaN(result)) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "This increment is illegal because it would result in a NaN"));
            return;
        }
        score.score = result;
        keyRegion.put(member, score);
        command.setResponse(Coder.getBulkStringResponse(context.getByteBufAllocator(), score.score));
    }
}

