/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.pdx.internal.json;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.LinkedList;
import java.util.List;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.pdx.internal.json.JSONToPdxMapper;
import org.apache.logging.log4j.Logger;

public class PdxListHelper {
    private static final Logger logger = LogService.getLogger();
    String m_name;
    PdxListHelper m_parent;
    List list = new LinkedList();

    private InternalCache getCache() {
        return (InternalCache)CacheFactory.getAnyInstance();
    }

    public PdxListHelper(PdxListHelper parent, String name) {
        InternalCache cache = this.getCache();
        this.m_name = name;
        if (logger.isTraceEnabled()) {
            logger.trace("PdxListHelper name: {}", (Object)name);
        }
        this.m_parent = parent;
    }

    public PdxListHelper getParent() {
        return this.m_parent;
    }

    public void setListName(String fieldName) {
        if (logger.isTraceEnabled()) {
            logger.trace("setListName fieldName: {}", (Object)fieldName);
        }
        this.m_name = fieldName;
    }

    public void addStringField(String fieldValue) {
        if (logger.isTraceEnabled()) {
            logger.trace("addStringField fieldValue: {}", (Object)fieldValue);
        }
        this.list.add(fieldValue);
    }

    public void addByteField(byte fieldValue) {
        if (logger.isTraceEnabled()) {
            logger.trace("addByteField fieldValue: {}", (Object)fieldValue);
        }
        this.list.add(fieldValue);
    }

    public void addShortField(short fieldValue) {
        if (logger.isTraceEnabled()) {
            logger.trace("addShortField fieldValue: {}", (Object)fieldValue);
        }
        this.list.add(fieldValue);
    }

    public void addIntField(int fieldValue) {
        if (logger.isTraceEnabled()) {
            logger.trace("addIntField fieldValue: {}", (Object)fieldValue);
        }
        this.list.add(fieldValue);
    }

    public void addLongField(long fieldValue) {
        if (logger.isTraceEnabled()) {
            logger.trace("addLongField fieldValue: {}", (Object)fieldValue);
        }
        this.list.add(fieldValue);
    }

    public void addBigIntegerField(BigInteger fieldValue) {
        if (logger.isTraceEnabled()) {
            logger.trace("addBigIntegerField fieldValue: {}", (Object)fieldValue);
        }
        this.list.add(fieldValue);
    }

    public void addBooleanField(boolean fieldValue) {
        if (logger.isTraceEnabled()) {
            logger.trace("addBooleanField fieldValue: {}", (Object)fieldValue);
        }
        this.list.add(fieldValue);
    }

    public void addFloatField(float fieldValue) {
        if (logger.isTraceEnabled()) {
            logger.trace("addFloatField fieldValue: {}", (Object)Float.valueOf(fieldValue));
        }
        this.list.add(Float.valueOf(fieldValue));
    }

    public void addDoubleField(double fieldValue) {
        if (logger.isTraceEnabled()) {
            logger.trace("addDoubleField fieldValue: {}", (Object)fieldValue);
        }
        this.list.add(fieldValue);
    }

    public void addBigDecimalField(BigDecimal fieldValue) {
        if (logger.isTraceEnabled()) {
            logger.trace("addBigDecimalField fieldValue: {}", (Object)fieldValue);
        }
        this.list.add(fieldValue);
    }

    public void addNullField(Object fieldValue) {
        if (logger.isTraceEnabled()) {
            logger.trace("addNULLField fieldValue: {}", fieldValue);
        }
        this.list.add(fieldValue);
    }

    public PdxListHelper addListField() {
        if (logger.isTraceEnabled()) {
            logger.trace("addListField");
        }
        PdxListHelper tmp = new PdxListHelper(this, "no-name");
        this.list.add(tmp.getList());
        return tmp;
    }

    public PdxListHelper endListField() {
        if (logger.isTraceEnabled()) {
            logger.trace("endListField");
        }
        return this.m_parent;
    }

    public void addObjectField(String fieldName, JSONToPdxMapper dpi) {
        if (fieldName != null) {
            throw new IllegalStateException("addObjectField:list should have object no fieldname");
        }
        if (logger.isTraceEnabled()) {
            logger.trace("addObjectField fieldName: {}", (Object)fieldName);
        }
        this.list.add(dpi.getPdxInstance());
    }

    public void endObjectField(String fieldName) {
        if (logger.isTraceEnabled()) {
            logger.trace("endObjectField fieldName: {}", (Object)fieldName);
        }
    }

    public List getList() {
        return this.list;
    }
}

