/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.pdx.internal;

import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.geode.DataSerializer;
import org.apache.geode.internal.DSCODE;
import org.apache.geode.internal.HeapDataOutputStream;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.Sendable;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.pdx.PdxInstance;
import org.apache.geode.pdx.PdxSerializationException;
import org.apache.geode.pdx.WritablePdxInstance;
import org.apache.geode.pdx.internal.ComparableEnum;
import org.apache.geode.pdx.internal.ConvertableToBytes;

public class PdxInstanceEnum
implements PdxInstance,
Sendable,
ConvertableToBytes,
ComparableEnum {
    private static final long serialVersionUID = -7417287878052772302L;
    private final String className;
    private final String enumName;
    private final int enumOrdinal;
    private static final List<String> fieldNames;

    public PdxInstanceEnum(String className, String enumName, int enumOrdinal) {
        this.className = className;
        this.enumName = enumName;
        this.enumOrdinal = enumOrdinal;
    }

    public PdxInstanceEnum(Enum<?> e) {
        this.className = e.getDeclaringClass().getName();
        this.enumName = e.name();
        this.enumOrdinal = e.ordinal();
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public String getName() {
        return this.enumName;
    }

    @Override
    public boolean isEnum() {
        return true;
    }

    @Override
    public int getOrdinal() {
        return this.enumOrdinal;
    }

    @Override
    public Object getObject() {
        Class<?> c;
        try {
            c = InternalDataSerializer.getCachedClass(this.className);
        }
        catch (ClassNotFoundException ex) {
            throw new PdxSerializationException(LocalizedStrings.DataSerializer_COULD_NOT_CREATE_AN_INSTANCE_OF_A_CLASS_0.toLocalizedString(this.className), ex);
        }
        try {
            return Enum.valueOf(c, this.enumName);
        }
        catch (IllegalArgumentException ex) {
            throw new PdxSerializationException("Enum could not be deserialized because \"" + this.enumName + "\" is not a valid name in enum class " + c, ex);
        }
    }

    @Override
    public boolean hasField(String fieldName) {
        return this.getFieldNames().contains(fieldName);
    }

    @Override
    public List<String> getFieldNames() {
        return fieldNames;
    }

    @Override
    public boolean isIdentityField(String fieldName) {
        return false;
    }

    @Override
    public Object getField(String fieldName) {
        if ("name".equals(fieldName)) {
            return this.enumName;
        }
        if ("ordinal".equals(fieldName)) {
            return this.enumOrdinal;
        }
        return null;
    }

    @Override
    public WritablePdxInstance createWriter() {
        throw new IllegalStateException("PdxInstances that are an enum can not be modified.");
    }

    @Override
    public void sendTo(DataOutput out) throws IOException {
        out.writeByte(DSCODE.PDX_INLINE_ENUM.toByte());
        DataSerializer.writeString(this.className, out);
        DataSerializer.writeString(this.enumName, out);
        InternalDataSerializer.writeArrayLength(this.enumOrdinal, out);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        result = 31 * result + (this.enumName == null ? 0 : this.enumName.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComparableEnum)) {
            return false;
        }
        ComparableEnum other = (ComparableEnum)obj;
        if (this.className == null ? other.getClassName() != null : !this.className.equals(other.getClassName())) {
            return false;
        }
        return !(this.enumName == null ? other.getName() != null : !this.enumName.equals(other.getName()));
    }

    @Override
    public String toString() {
        return this.enumName;
    }

    @Override
    public byte[] toBytes() throws IOException {
        HeapDataOutputStream hdos = new HeapDataOutputStream(Version.CURRENT);
        this.sendTo(hdos);
        return hdos.toByteArray();
    }

    public int compareTo(Object o) {
        if (o instanceof ComparableEnum) {
            ComparableEnum other = (ComparableEnum)o;
            if (!this.getClassName().equals(other.getClassName())) {
                throw new ClassCastException("Can not compare a " + this.getClassName() + " to a " + other.getClassName());
            }
            return this.getOrdinal() - other.getOrdinal();
        }
        throw new ClassCastException("Can not compare an instance of " + o.getClass() + " to a " + this.getClass());
    }

    static {
        ArrayList<String> tmp = new ArrayList<String>(2);
        tmp.add("name");
        tmp.add("ordinal");
        fieldNames = Collections.unmodifiableList(tmp);
    }
}

