/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.deployment;

import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanResult;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.HashSet;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionAdapter;

public class FunctionScanner {
    public Collection<String> findFunctionsInJar(File jarFile) throws IOException {
        URLClassLoader urlClassLoader = new URLClassLoader(new URL[]{jarFile.getCanonicalFile().toURL()});
        FastClasspathScanner fastClasspathScanner = new FastClasspathScanner(new String[]{"-dir:"}).removeTemporaryFilesAfterScan(true).overrideClassLoaders(new ClassLoader[]{urlClassLoader});
        ScanResult scanResult = fastClasspathScanner.scan();
        HashSet<String> functionClasses = new HashSet<String>();
        functionClasses.addAll(scanResult.getNamesOfClassesImplementing(Function.class));
        functionClasses.addAll(scanResult.getNamesOfSubclassesOf(FunctionAdapter.class));
        return functionClasses;
    }
}

