/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.result;

import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.json.GfJsonException;
import org.apache.geode.management.internal.cli.json.GfJsonObject;
import org.apache.geode.management.internal.cli.result.InfoResultData;
import org.apache.geode.management.internal.cli.result.ResultDataException;

public class ErrorResultData
extends InfoResultData {
    private static final String ERROR_CODE = "errorCode";

    public ErrorResultData() {
    }

    public ErrorResultData(String message) {
        super(message);
    }

    ErrorResultData(GfJsonObject gfJsonObject) {
        super(gfJsonObject);
    }

    public int getErrorCode() {
        Integer code = (Integer)this.contentObject.get(ERROR_CODE);
        if (code == null) {
            return 400;
        }
        return code;
    }

    public ErrorResultData setErrorCode(int errorCode) {
        try {
            this.contentObject.putOpt(ERROR_CODE, errorCode);
        }
        catch (GfJsonException e) {
            throw new ResultDataException(e.getMessage());
        }
        return this;
    }

    @Override
    public ErrorResultData setHeader(String headerText) {
        return (ErrorResultData)super.setHeader(headerText);
    }

    @Override
    public ErrorResultData addLine(String line) {
        return (ErrorResultData)super.addLine(line);
    }

    @Override
    public ErrorResultData setFooter(String footerText) {
        return (ErrorResultData)super.setFooter(footerText);
    }

    @Override
    public String getType() {
        return "error";
    }

    @Override
    public void setStatus(Result.Status status) {
        if (status != Result.Status.ERROR) {
            throw new UnsupportedOperationException("The status of an ErrorResultData result must always be ERROR");
        }
    }

    @Override
    public Result.Status getStatus() {
        return Result.Status.ERROR;
    }
}

