/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.result;

import java.util.Iterator;
import org.apache.geode.management.internal.cli.json.GfJsonArray;
import org.apache.geode.management.internal.cli.json.GfJsonException;
import org.apache.geode.management.internal.cli.json.GfJsonObject;
import org.apache.geode.management.internal.cli.result.AbstractResultData;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.ResultDataException;
import org.apache.geode.management.internal.cli.result.TabularResultData;

public class CompositeResultData
extends AbstractResultData {
    public static String SEPARATOR = "__separator__";
    private int subsectionCount;

    CompositeResultData() {
    }

    CompositeResultData(GfJsonObject gfJsonObject) {
        super(gfJsonObject);
    }

    @Override
    public String getType() {
        return "composite";
    }

    @Override
    public CompositeResultData setHeader(String headerText) {
        return (CompositeResultData)super.setHeader(headerText);
    }

    @Override
    public CompositeResultData setFooter(String footerText) {
        return (CompositeResultData)super.setFooter(footerText);
    }

    public SectionResultData addSection() {
        return this.addSection(String.valueOf(this.subsectionCount));
    }

    public SectionResultData addSection(String keyToAccess) {
        GfJsonObject sectionData = new GfJsonObject();
        try {
            this.contentObject.putAsJSONObject(SectionResultData.generateSectionKey(keyToAccess), sectionData);
        }
        catch (GfJsonException e) {
            throw new ResultDataException(e.getMessage());
        }
        ++this.subsectionCount;
        return new SectionResultData(sectionData);
    }

    public SectionResultData addSection(SectionResultData otherSection) {
        String keyToAccess = String.valueOf(this.subsectionCount);
        GfJsonObject sectionData = otherSection.getSectionGfJsonObject();
        try {
            this.contentObject.putAsJSONObject(SectionResultData.generateSectionKey(keyToAccess), sectionData);
        }
        catch (GfJsonException e) {
            throw new ResultDataException(e.getMessage());
        }
        ++this.subsectionCount;
        return new SectionResultData(sectionData);
    }

    public CompositeResultData addSeparator(char buildSeparatorFrom) {
        try {
            this.contentObject.put(SEPARATOR, Character.valueOf(buildSeparatorFrom));
        }
        catch (GfJsonException e) {
            throw new ResultDataException(e.getMessage());
        }
        return this;
    }

    public SectionResultData retrieveSectionByIndex(int index) {
        SectionResultData sectionToRetrieve = null;
        int i = 0;
        Iterator<String> iterator = this.contentObject.keys();
        while (iterator.hasNext()) {
            String key = iterator.next();
            if (!key.startsWith("__sections__")) continue;
            if (i == index) {
                sectionToRetrieve = new SectionResultData(this.contentObject.getJSONObject(key));
                break;
            }
            ++i;
        }
        return sectionToRetrieve;
    }

    public SectionResultData retrieveSection(String keyToRetrieve) {
        SectionResultData sectionToRetrieve = null;
        if (this.contentObject.has(SectionResultData.generateSectionKey(keyToRetrieve))) {
            GfJsonObject sectionData = this.contentObject.getJSONObject(SectionResultData.generateSectionKey(keyToRetrieve));
            sectionToRetrieve = new SectionResultData(sectionData);
        }
        return sectionToRetrieve;
    }

    public static void main(String[] args) {
        CompositeResultData crd = new CompositeResultData();
        SectionResultData r1Section = crd.addSection("R1");
        r1Section.addData("Region", "R1").addData("IsPartitioned", false).addData("IsPersistent", true).addData("Disk Store", "DiskStore1").addData("Group", "Group1");
        TabularResultData r1Table = r1Section.addTable("R1Members");
        r1Table.accumulate("Member Id", "host1(3467):12435:12423").accumulate("PrimaryEntryCount", 20000).accumulate("BackupEntryCount", 20000).accumulate("Memory(MB)", "100").accumulate("NumOfCopies", 1);
        r1Table.accumulate("Member Id", "host3(5756):57665:90923").accumulate("PrimaryEntryCount", 25000).accumulate("BackupEntryCount", 10000).accumulate("Memory(MB)", "200").accumulate("NumOfCopies", 1);
        SectionResultData r3Section = crd.addSection("R3");
        r3Section.addData("Region", "R3").addData("IsPartitioned", true).addData("IsPersistent", true).addData("Disk Store", "DiskStore2").addData("Group", "Group2").addData("ColocatedWith", "-");
        SectionResultData r3SubSection = r3Section.addSection("R3Config");
        r3SubSection.addData("Configuration", "");
        r3SubSection.addData("Config1", "abcd");
        r3SubSection.addData("Config2", "abcde");
        r3SubSection.addData("Config3", "abcdfg");
        TabularResultData r3Table = r3Section.addTable("R3Members");
        r3Table.accumulate("Member Id", "host1(3467):12435:12423").accumulate("PrimaryEntryCount", 20000).accumulate("BackupEntryCount", 20000).accumulate("Memory(MB)", "100").accumulate("NumOfCopies", 1).accumulate("NumOfBuckets", 100);
        r3Table.accumulate("Member Id", "host2(3353):23545:14723").accumulate("PrimaryEntryCount", 20000).accumulate("BackupEntryCount", 20000).accumulate("Memory(MB)", "100").accumulate("NumOfCopies", 1).accumulate("NumOfBuckets", 100);
        r3Table.accumulate("Member Id", "host3(5756):57665:90923").accumulate("PrimaryEntryCount", 25000).accumulate("BackupEntryCount", 10000).accumulate("Memory(MB)", "200").accumulate("NumOfCopies", 1).accumulate("NumOfBuckets", 100);
        try {
            System.out.println(crd.getGfJsonObject().toIndentedString(0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class SectionResultData {
        protected GfJsonObject sectionGfJsonObject;
        private int subsectionCount = 0;
        private int tablesCount = 0;

        SectionResultData() {
            this.sectionGfJsonObject = new GfJsonObject();
        }

        public SectionResultData(GfJsonObject gfJsonObject) {
            this.sectionGfJsonObject = gfJsonObject;
        }

        public GfJsonObject getSectionGfJsonObject() {
            return this.sectionGfJsonObject;
        }

        public String getHeader() {
            return this.sectionGfJsonObject.getString("header");
        }

        public String getFooter() {
            return this.sectionGfJsonObject.getString("footer");
        }

        public SectionResultData setHeader(String headerText) {
            try {
                this.sectionGfJsonObject.put("header", headerText);
            }
            catch (GfJsonException e) {
                throw new ResultDataException(e.getMessage());
            }
            return this;
        }

        public SectionResultData setFooter(String footerText) {
            try {
                this.sectionGfJsonObject.put("footer", footerText);
            }
            catch (GfJsonException e) {
                throw new ResultDataException(e.getMessage());
            }
            return this;
        }

        public SectionResultData addSeparator(char buildSeparatorFrom) {
            try {
                this.sectionGfJsonObject.put(SEPARATOR, Character.valueOf(buildSeparatorFrom));
            }
            catch (GfJsonException e) {
                throw new ResultDataException(e.getMessage());
            }
            return this;
        }

        public SectionResultData addData(String name, Object value) {
            try {
                this.sectionGfJsonObject.put(name, value);
            }
            catch (GfJsonException e) {
                throw new ResultDataException(e.getMessage());
            }
            return this;
        }

        public SectionResultData addSection() {
            return this.addSection(String.valueOf(this.subsectionCount));
        }

        public SectionResultData addSection(String keyToAccess) {
            GfJsonObject sectionData = new GfJsonObject();
            try {
                this.sectionGfJsonObject.putAsJSONObject(SectionResultData.generateSectionKey(keyToAccess), sectionData);
            }
            catch (GfJsonException e) {
                throw new ResultDataException(e.getMessage());
            }
            ++this.subsectionCount;
            return new SectionResultData(sectionData);
        }

        public TabularResultData addTable() {
            return this.addTable(String.valueOf(this.tablesCount));
        }

        public TabularResultData addTable(String keyToAccess) {
            TabularResultData tabularResultData = ResultBuilder.createTabularResultData();
            GfJsonObject tableData = tabularResultData.getGfJsonObject();
            try {
                this.sectionGfJsonObject.putAsJSONObject(SectionResultData.generateTableKey(keyToAccess), tableData);
            }
            catch (GfJsonException e) {
                throw new ResultDataException(e.getMessage());
            }
            ++this.tablesCount;
            return tabularResultData;
        }

        public SectionResultData retrieveSectionByIndex(int index) {
            SectionResultData sectionToRetrieve = null;
            int i = 0;
            Iterator<String> iterator = this.sectionGfJsonObject.keys();
            while (iterator.hasNext()) {
                String key = iterator.next();
                if (!key.startsWith("__sections__")) continue;
                if (i == index) {
                    sectionToRetrieve = new SectionResultData(this.sectionGfJsonObject.getJSONObject(key));
                    break;
                }
                ++i;
            }
            return sectionToRetrieve;
        }

        public SectionResultData retrieveSection(String keyToRetrieve) {
            SectionResultData sectionToRetrieve = null;
            if (this.sectionGfJsonObject.has(SectionResultData.generateSectionKey(keyToRetrieve))) {
                GfJsonObject sectionData = this.sectionGfJsonObject.getJSONObject(SectionResultData.generateSectionKey(keyToRetrieve));
                sectionToRetrieve = new SectionResultData(sectionData);
            }
            return sectionToRetrieve;
        }

        public TabularResultData retrieveTableByIndex(int index) {
            TabularResultData tabularResultData = null;
            int i = 0;
            Iterator<String> iterator = this.sectionGfJsonObject.keys();
            while (iterator.hasNext()) {
                String key = iterator.next();
                if (!key.startsWith("__tables__")) continue;
                if (i == index) {
                    tabularResultData = new TabularResultData(this.sectionGfJsonObject.getJSONObject(key));
                    break;
                }
                ++i;
            }
            return tabularResultData;
        }

        public TabularResultData retrieveTable(String keyToRetrieve) {
            TabularResultData tabularResultData = null;
            if (this.sectionGfJsonObject.has(SectionResultData.generateTableKey(keyToRetrieve))) {
                GfJsonObject tableData = this.sectionGfJsonObject.getJSONObject(SectionResultData.generateTableKey(keyToRetrieve));
                tabularResultData = new TabularResultData(tableData);
            }
            return tabularResultData;
        }

        public Object retrieveObject(String name) {
            Object retrievedObject = this.sectionGfJsonObject.get(name);
            if (retrievedObject instanceof GfJsonArray) {
                GfJsonArray.toStringArray((GfJsonArray)retrievedObject);
            }
            return this.sectionGfJsonObject.get(name);
        }

        public String retrieveString(String name) {
            return this.sectionGfJsonObject.getString(name);
        }

        public String[] retrieveStringArray(String name) {
            String[] stringArray;
            Object retrievedObject = this.sectionGfJsonObject.get(name);
            if (retrievedObject instanceof GfJsonArray) {
                stringArray = GfJsonArray.toStringArray((GfJsonArray)retrievedObject);
            } else {
                try {
                    stringArray = GfJsonArray.toStringArray(new GfJsonArray(retrievedObject));
                }
                catch (GfJsonException e) {
                    throw new ResultDataException(e.getMessage());
                }
            }
            return stringArray;
        }

        public static String generateSectionKey(String keyToRetrieve) {
            return "__sections__-" + keyToRetrieve;
        }

        public static String generateTableKey(String keyToRetrieve) {
            return "__tables__-" + keyToRetrieve;
        }
    }
}

