/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import org.apache.geode.cache.Cache;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.management.internal.cli.domain.RegionDescriptionPerMember;

public class GetRegionDescriptionFunction
implements InternalFunction {
    private static final long serialVersionUID = 1L;

    @Override
    public void execute(FunctionContext context) {
        String regionPath = (String)context.getArguments();
        try {
            Cache cache = context.getCache();
            Region region = cache.getRegion(regionPath);
            if (region != null) {
                String memberName = cache.getDistributedSystem().getDistributedMember().getName();
                RegionDescriptionPerMember regionDescription = new RegionDescriptionPerMember(region, memberName);
                context.getResultSender().lastResult(regionDescription);
            } else {
                context.getResultSender().lastResult(null);
            }
        }
        catch (Exception e) {
            context.getResultSender().sendException(e);
        }
    }
}

