/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import org.apache.geode.cache.DiskStore;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.functions.DestroyDiskStoreFunctionArgs;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;

public class DestroyDiskStoreFunction
implements InternalFunction {
    private static final long serialVersionUID = 1L;

    @Override
    public void execute(FunctionContext context) {
        CliFunctionResult result;
        DestroyDiskStoreFunctionArgs args = (DestroyDiskStoreFunctionArgs)context.getArguments();
        InternalCache cache = (InternalCache)context.getCache();
        DistributedMember member = cache.getDistributedSystem().getDistributedMember();
        String memberId = member.getId();
        if (!member.getName().equals("")) {
            memberId = member.getName();
        }
        DiskStore diskStore = cache.findDiskStore(args.getId());
        try {
            if (diskStore != null) {
                XmlEntity xmlEntity = new XmlEntity("disk-store", "name", args.getId());
                diskStore.destroy();
                result = new CliFunctionResult(memberId, xmlEntity, "Success");
            } else {
                result = args.isIfExists() ? new CliFunctionResult(memberId, true, "Skipping: Disk store not found on this member") : new CliFunctionResult(memberId, false, "Disk store not found on this member");
            }
        }
        catch (IllegalStateException ex) {
            result = new CliFunctionResult(memberId, false, ex.getMessage());
        }
        context.getResultSender().lastResult(result);
    }
}

