/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.util.HashMap;
import java.util.Properties;
import joptsimple.internal.Strings;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.Declarable;
import org.apache.geode.cache.asyncqueue.AsyncEventListener;
import org.apache.geode.cache.asyncqueue.AsyncEventQueueFactory;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.wan.GatewayEventFilter;
import org.apache.geode.cache.wan.GatewayEventSubstitutionFilter;
import org.apache.geode.cache.wan.GatewaySender;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.ClassPathLoader;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.internal.cli.functions.AsyncEventQueueFunctionArgs;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;
import org.apache.logging.log4j.Logger;

public class CreateAsyncEventQueueFunction
implements InternalFunction {
    private static final Logger logger = LogService.getLogger();
    private static final long serialVersionUID = 1L;

    @Override
    public void execute(FunctionContext context) {
        String memberId = "";
        try {
            String gatewaySubstitutionFilter;
            AsyncEventQueueFunctionArgs aeqArgs = (AsyncEventQueueFunctionArgs)context.getArguments();
            InternalCache cache = (InternalCache)context.getCache();
            DistributedMember member = cache.getDistributedSystem().getDistributedMember();
            memberId = member.getId();
            if (!member.getName().equals("")) {
                memberId = member.getName();
            }
            AsyncEventQueueFactory asyncEventQueueFactory = cache.createAsyncEventQueueFactory().setParallel(aeqArgs.isParallel()).setBatchConflationEnabled(aeqArgs.isEnableBatchConflation()).setBatchSize(aeqArgs.getBatchSize()).setBatchTimeInterval(aeqArgs.getBatchTimeInterval()).setPersistent(aeqArgs.isPersistent()).setDiskStoreName(aeqArgs.getDiskStoreName()).setDiskSynchronous(aeqArgs.isDiskSynchronous()).setForwardExpirationDestroy(aeqArgs.isForwardExpirationDestroy()).setMaximumQueueMemory(aeqArgs.getMaxQueueMemory()).setDispatcherThreads(aeqArgs.getDispatcherThreads()).setOrderPolicy(GatewaySender.OrderPolicy.valueOf(aeqArgs.getOrderPolicy()));
            String[] gatewayEventFilters = aeqArgs.getGatewayEventFilters();
            if (gatewayEventFilters != null) {
                for (String gatewayEventFilter : gatewayEventFilters) {
                    asyncEventQueueFactory.addGatewayEventFilter((GatewayEventFilter)this.newInstance(gatewayEventFilter));
                }
            }
            if ((gatewaySubstitutionFilter = aeqArgs.getGatewaySubstitutionFilter()) != null) {
                asyncEventQueueFactory.setGatewayEventSubstitutionListener((GatewayEventSubstitutionFilter)this.newInstance(gatewaySubstitutionFilter));
            }
            String listenerClassName = aeqArgs.getListenerClassName();
            Class<?> listenerClass = InternalDataSerializer.getCachedClass(listenerClassName);
            Object listenerInstance = listenerClass.newInstance();
            Properties listenerProperties = aeqArgs.getListenerProperties();
            if (listenerProperties != null && !listenerProperties.isEmpty()) {
                if (!(listenerInstance instanceof Declarable)) {
                    throw new IllegalArgumentException("Listener properties were provided, but the listener specified does not implement Declarable.");
                }
                ((Declarable)listenerInstance).initialize(cache, listenerProperties);
                ((Declarable)listenerInstance).init(listenerProperties);
                HashMap<Declarable, Properties> declarablesMap = new HashMap<Declarable, Properties>();
                declarablesMap.put((Declarable)listenerInstance, listenerProperties);
                cache.addDeclarableProperties(declarablesMap);
            }
            asyncEventQueueFactory.create(aeqArgs.getAsyncEventQueueId(), (AsyncEventListener)listenerInstance);
            XmlEntity xmlEntity = new XmlEntity("async-event-queue", "id", aeqArgs.getAsyncEventQueueId());
            context.getResultSender().lastResult(new CliFunctionResult(memberId, xmlEntity, "Success"));
        }
        catch (CacheClosedException cce) {
            context.getResultSender().lastResult(new CliFunctionResult(memberId, false, null));
        }
        catch (Exception e) {
            logger.error("Could not create async event queue: {}", (Object)e.getMessage(), (Object)e);
            context.getResultSender().lastResult(new CliFunctionResult(memberId, e, null));
        }
    }

    private Object newInstance(String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (Strings.isNullOrEmpty((String)className)) {
            return null;
        }
        return ClassPathLoader.getLatest().forName(className).newInstance();
    }

    @Override
    public String getId() {
        return CreateAsyncEventQueueFunction.class.getName();
    }
}

