/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.domain;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.Scope;

public class RegionInformation
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String name;
    protected String path;
    protected Scope scope;
    protected DataPolicy dataPolicy;
    protected boolean isRoot;
    protected String parentRegion;
    private Set<RegionInformation> subRegionInformationSet = null;

    public RegionInformation(Region<?, ?> region, boolean recursive) {
        this.name = region.getFullPath().substring(1);
        this.path = region.getFullPath().substring(1);
        this.scope = region.getAttributes().getScope();
        this.dataPolicy = region.getAttributes().getDataPolicy();
        if (region.getParentRegion() == null) {
            this.isRoot = true;
            if (recursive) {
                Set<Region<?, ?>> subRegions = region.subregions(recursive);
                this.subRegionInformationSet = this.getSubRegions(subRegions);
            }
        } else {
            this.isRoot = false;
            this.parentRegion = region.getParentRegion().getFullPath();
        }
    }

    private Set<RegionInformation> getSubRegions(Set<Region<?, ?>> subRegions) {
        HashSet<RegionInformation> subRegionInformation = new HashSet<RegionInformation>();
        for (Region<?, ?> region : subRegions) {
            RegionInformation regionInformation = new RegionInformation(region, false);
            subRegionInformation.add(regionInformation);
        }
        return subRegionInformation;
    }

    public Set<String> getSubRegionNames() {
        HashSet<String> subRegionNames = new HashSet<String>();
        if (this.subRegionInformationSet != null) {
            for (RegionInformation regInfo : this.subRegionInformationSet) {
                subRegionNames.add(regInfo.getName());
            }
        }
        return subRegionNames;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public Scope getScope() {
        return this.scope;
    }

    public DataPolicy getDataPolicy() {
        return this.dataPolicy;
    }

    public Set<RegionInformation> getSubRegionInformation() {
        return this.subRegionInformationSet;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RegionInformation) {
            RegionInformation regionInfoObj = (RegionInformation)obj;
            return this.name.equals(regionInfoObj.getName()) && this.path.equals(regionInfoObj.getPath()) && this.isRoot == regionInfoObj.isRoot && this.dataPolicy.equals(regionInfoObj.getDataPolicy()) && this.scope.equals(regionInfoObj.getScope());
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.path.hashCode() ^ this.dataPolicy.hashCode() ^ this.scope.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nName          :\t");
        sb.append(this.getName());
        sb.append("\nPath          :\t");
        sb.append(this.getPath());
        sb.append("\nScope         :\t");
        sb.append(this.getScope().toString());
        sb.append("\nData Policy   :\t");
        sb.append(this.getDataPolicy().toString());
        if (this.parentRegion != null) {
            sb.append("\nParent Region :\t");
            sb.append(this.parentRegion);
        }
        return sb.toString();
    }

    public String getSubRegionInfoAsString() {
        StringBuilder sb = new StringBuilder();
        if (this.isRoot) {
            for (RegionInformation regionInfo : this.subRegionInformationSet) {
                sb.append("\n");
                sb.append(regionInfo.getName());
            }
        }
        return sb.toString();
    }
}

