/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import org.apache.commons.lang.StringUtils;
import org.apache.geode.internal.security.SecurableCommunicationChannel;
import org.apache.geode.management.internal.cli.shell.Gfsh;

public class UserInputProperty {
    public static UserInputProperty USERNAME = new UserInputProperty("security-username", "user", false);
    public static UserInputProperty PASSWORD = new UserInputProperty("security-password", "password", "", true);
    public static UserInputProperty KEYSTORE = new UserInputProperty("ssl-keystore", "key-store", "", false);
    public static UserInputProperty KEYSTORE_PASSWORD = new UserInputProperty("ssl-keystore-password", "key-store-password", "", true);
    public static UserInputProperty KEYSTORE_TYPE = new UserInputProperty("ssl-keystore-type", "key-store-type", "JKS", false);
    public static UserInputProperty TRUSTSTORE = new UserInputProperty("ssl-truststore", "trust-store", "", false);
    public static UserInputProperty TRUSTSTORE_PASSWORD = new UserInputProperty("ssl-truststore-password", "trust-store-password", "", true);
    public static UserInputProperty TRUSTSTORE_TYPE = new UserInputProperty("ssl-truststore-type", "trust-store-type", "JKS", false);
    public static UserInputProperty CIPHERS = new UserInputProperty("ssl-ciphers", "ssl-ciphers", "any", false);
    public static UserInputProperty PROTOCOL = new UserInputProperty("ssl-protocols", "ssl-protocols", "any", false);
    public static UserInputProperty COMPONENT = new UserInputProperty("ssl-enabled-components", "ssl-enabled-components", SecurableCommunicationChannel.ALL.getConstant(), false);
    private final String key;
    private final String prompt;
    private final boolean isMasked;
    private final String defaultValue;

    UserInputProperty(String key, String prompt, boolean isMasked) {
        this(key, prompt, null, isMasked);
    }

    UserInputProperty(String key, String prompt, String defaultValue, boolean isMasked) {
        this.key = key;
        this.prompt = prompt;
        this.defaultValue = defaultValue;
        this.isMasked = isMasked;
    }

    public String promptForAcceptableValue(Gfsh gfsh) {
        if (gfsh.isQuietMode() || gfsh.isHeadlessMode()) {
            return this.defaultValue == null ? "" : this.defaultValue;
        }
        String value = this.promptForUserInput(gfsh);
        if (value.length() > 0) {
            return value;
        }
        if (value.length() == 0 && this.defaultValue != null) {
            return this.defaultValue;
        }
        while (value.length() == 0) {
            value = this.promptForUserInput(gfsh);
        }
        return value;
    }

    private String promptForUserInput(Gfsh gfsh) {
        String promptText = StringUtils.isBlank((String)this.defaultValue) ? this.prompt + ": " : this.prompt + "(default: " + this.defaultValue + "): ";
        String value = this.isMasked ? gfsh.readPassword(promptText) : gfsh.readText(promptText);
        if (value == null) {
            value = "";
        }
        return value;
    }

    public String getKey() {
        return this.key;
    }
}

