/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.commands.InternalGfshCommand;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.functions.ListFunctionFunction;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.TabularResultData;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class ListFunctionCommand
extends InternalGfshCommand {
    private final ListFunctionFunction listFunctionFunction = new ListFunctionFunction();

    @CliCommand(value={"list functions"}, help="Display a list of registered functions. The default is to display functions for all members.")
    @CliMetaData(relatedTopic={"Function Execution"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public Result listFunction(@CliOption(key={"matches"}, help="Pattern that the function ID must match in order to be included. Uses Java pattern matching rules, not UNIX. For example, to match any character any number of times use \".*\" instead of \"*\".") String matches, @CliOption(key={"group", "groups"}, optionContext="geode.converter.member.groups:disable-string-converter", help="Group(s) of members for which functions will be displayed.") String[] groups, @CliOption(key={"member", "members"}, optionContext="geode.converter.member.idOrName:disable-string-converter", help="Name/Id of the member(s) for which functions will be displayed.") String[] members) {
        TabularResultData tabularData = ResultBuilder.createTabularResultData();
        boolean accumulatedData = false;
        Set<DistributedMember> targetMembers = this.findMembers(groups, members);
        if (targetMembers.isEmpty()) {
            return ResultBuilder.createUserErrorResult("No Members Found");
        }
        try {
            ResultCollector<?, ?> rc = CliUtil.executeFunction(this.listFunctionFunction, new Object[]{matches}, targetMembers);
            List<CliFunctionResult> results = CliFunctionResult.cleanResults((List)rc.getResult());
            for (CliFunctionResult result : results) {
                if (result.getThrowable() != null) {
                    tabularData.accumulate("Member", result.getMemberIdOrName());
                    tabularData.accumulate("Function", "<ERROR: " + result.getThrowable().getMessage() + ">");
                    accumulatedData = true;
                    tabularData.setStatus(Result.Status.ERROR);
                    continue;
                }
                if (!result.isSuccessful()) continue;
                Object[] strings = (String[])result.getSerializables();
                Arrays.sort(strings);
                for (Object string : strings) {
                    tabularData.accumulate("Member", result.getMemberIdOrName());
                    tabularData.accumulate("Function", string);
                    accumulatedData = true;
                }
            }
            if (!accumulatedData) {
                return ResultBuilder.createInfoResult("No Functions Found");
            }
            return ResultBuilder.buildResult(tabularData);
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable th) {
            SystemFailure.checkFailure();
            return ResultBuilder.createGemFireErrorResult("Exception while attempting to list functions: " + th.getMessage());
        }
    }
}

