/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.List;
import java.util.Objects;
import org.apache.geode.management.ManagementService;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.shell.Gfsh;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;

public abstract class InternalGfshCommand
extends GfshCommand {
    public static final String EXPERIMENTAL = "(Experimental) ";

    public void persistClusterConfiguration(Result result, Runnable runnable) {
        if (result == null) {
            throw new IllegalArgumentException("Result should not be null");
        }
        if (this.getConfigurationService() == null) {
            result.setCommandPersisted(false);
        } else {
            runnable.run();
            result.setCommandPersisted(true);
        }
    }

    public XmlEntity findXmlEntity(List<CliFunctionResult> functionResults) {
        return functionResults.stream().filter(CliFunctionResult::isSuccessful).map(CliFunctionResult::getXmlEntity).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public boolean isDebugging() {
        return this.getGfsh() != null && this.getGfsh().getDebug();
    }

    public boolean isLogging() {
        return this.getGfsh() != null;
    }

    public Gfsh getGfsh() {
        return Gfsh.getCurrentInstance();
    }

    public ManagementService getManagementService() {
        return ManagementService.getExistingManagementService(this.getCache());
    }
}

