/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.List;
import java.util.Set;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.InternalClusterConfigurationService;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.commands.InternalGfshCommand;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.functions.GatewaySenderDestroyFunction;
import org.apache.geode.management.internal.cli.functions.GatewaySenderDestroyFunctionArgs;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.apache.logging.log4j.Logger;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class DestroyGatewaySenderCommand
extends InternalGfshCommand {
    private static final Logger logger = LogService.getLogger();

    @CliCommand(value={"destroy gateway-sender"}, help="Destroy the Gateway Sender on a member or members.")
    @CliMetaData(relatedTopic={"WAN"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE, target=ResourcePermission.Target.GATEWAY)
    public Result destroyGatewaySender(@CliOption(key={"group", "groups"}, optionContext="geode.converter.member.groups:disable-string-converter", help="Group(s) of members on which to destroy the Gateway Sender.") String[] onGroups, @CliOption(key={"member", "members"}, optionContext="geode.converter.member.idOrName:disable-string-converter", help="Name/Id of the member on which to destroy the Gateway Sender.") String[] onMember, @CliOption(key={"id"}, mandatory=true, optionContext="geode.converter.gateway.senderid:disable-string-converter", help="Id of the GatewaySender.") String id, @CliOption(key={"if-exists"}, help="If true, the command will be a no-op if the entity does not exist.", specifiedDefaultValue="true", unspecifiedDefaultValue="false") boolean ifExist) {
        GatewaySenderDestroyFunctionArgs gatewaySenderDestroyFunctionArgs = new GatewaySenderDestroyFunctionArgs(id, ifExist);
        Set<DistributedMember> members = this.getMembers(onGroups, onMember);
        List<CliFunctionResult> functionResults = this.executeAndGetFunctionResult(GatewaySenderDestroyFunction.INSTANCE, gatewaySenderDestroyFunctionArgs, members);
        CommandResult result = ResultBuilder.buildResult(functionResults);
        XmlEntity xmlEntity = this.findXmlEntity(functionResults);
        if (xmlEntity == null) {
            return result;
        }
        if (onMember != null || this.getConfigurationService() == null) {
            result.setCommandPersisted(false);
            return result;
        }
        ((InternalClusterConfigurationService)this.getConfigurationService()).deleteXmlEntity(xmlEntity, onGroups);
        return result;
    }
}

