/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.List;
import java.util.Set;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.InternalClusterConfigurationService;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.commands.InternalGfshCommand;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.functions.DestroyDiskStoreFunction;
import org.apache.geode.management.internal.cli.functions.DestroyDiskStoreFunctionArgs;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class DestroyDiskStoreCommand
extends InternalGfshCommand {
    @CliCommand(value={"destroy disk-store"}, help="Destroy a disk store, including deleting all files on disk used by the disk store. Data for closed regions previously using the disk store will be lost.")
    @CliMetaData(relatedTopic={"Disk Store"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE, target=ResourcePermission.Target.DISK)
    public Result destroyDiskStore(@CliOption(key={"name"}, mandatory=true, help="Name of the disk store that will be destroyed.") String name, @CliOption(key={"group", "groups"}, help="Group(s) of members on which the disk store will be destroyed. If no group is specified the disk store will be destroyed on all members.", optionContext="geode.converter.member.groups:disable-string-converter") String[] groups, @CliOption(key={"if-exists"}, help="If true, the command will be a no-op if the entity does not exist.", specifiedDefaultValue="true", unspecifiedDefaultValue="false") boolean ifExist) {
        Set<DistributedMember> targetMembers = this.findMembers(groups, null);
        if (targetMembers.isEmpty()) {
            return ResultBuilder.createUserErrorResult("No Members Found");
        }
        DestroyDiskStoreFunctionArgs functionArgs = new DestroyDiskStoreFunctionArgs(name, ifExist);
        List<CliFunctionResult> results = this.executeAndGetFunctionResult(new DestroyDiskStoreFunction(), functionArgs, targetMembers);
        CommandResult result = ResultBuilder.buildResult(results);
        XmlEntity xmlEntity = this.findXmlEntity(results);
        if (xmlEntity != null) {
            this.persistClusterConfiguration(result, () -> ((InternalClusterConfigurationService)this.getConfigurationService()).deleteXmlEntity(xmlEntity, groups));
        }
        return result;
    }
}

