/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import org.apache.geode.SystemFailure;
import org.apache.geode.internal.cache.DiskStoreImpl;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.commands.InternalGfshCommand;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class DescribeOfflineDiskStoreCommand
extends InternalGfshCommand {
    @CliCommand(value={"describe offline-disk-store"}, help="Display information about an offline disk store.")
    @CliMetaData(shellOnly=true, relatedTopic={"Disk Store"})
    public Result describeOfflineDiskStore(@CliOption(key={"name"}, mandatory=true, help="Name of the disk store to be described.") String diskStoreName, @CliOption(key={"disk-dirs"}, mandatory=true, help="Directories which contain the disk store files.") String[] diskDirs, @CliOption(key={"pdx"}, help="Display all the pdx types stored in the disk store") Boolean listPdxTypes, @CliOption(key={"region"}, help="Name/Path of the region in the disk store to be described.") String regionName) {
        try {
            File[] dirs = new File[diskDirs.length];
            for (int i = 0; i < diskDirs.length; ++i) {
                dirs[i] = new File(diskDirs[i]);
            }
            if ("/".equals(regionName)) {
                return ResultBuilder.createUserErrorResult("Invalid region name");
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(outputStream);
            DiskStoreImpl.dumpInfo(printStream, diskStoreName, dirs, regionName, listPdxTypes);
            return ResultBuilder.createInfoResult(outputStream.toString());
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable th) {
            SystemFailure.checkFailure();
            if (th.getMessage() == null) {
                return ResultBuilder.createGemFireErrorResult("An error occurred while describing offline disk stores: " + th);
            }
            return ResultBuilder.createGemFireErrorResult("An error occurred while describing offline disk stores: " + th.getMessage());
        }
    }
}

