/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.commands.InternalGfshCommand;
import org.apache.geode.management.internal.cli.domain.CacheServerInfo;
import org.apache.geode.management.internal.cli.domain.MemberInformation;
import org.apache.geode.management.internal.cli.functions.GetMemberInformationFunction;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.CompositeResultData;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class DescribeMemberCommand
extends InternalGfshCommand {
    private static final GetMemberInformationFunction getMemberInformation = new GetMemberInformationFunction();

    @CliCommand(value={"describe member"}, help="Display information about a member, including name, id, groups, regions, etc.")
    @CliMetaData(relatedTopic={"Server"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public Result describeMember(@CliOption(key={"name"}, optionContext="geode.converter.all.member.idOrName:disable-string-converter", help="Display information about a member, including name, id, groups, regions, etc.", mandatory=true) String memberNameOrId) {
        Result result = null;
        try {
            DistributedMember memberToBeDescribed = this.getMember(memberNameOrId);
            ResultCollector<?, ?> rc = this.executeFunction((Function)getMemberInformation, null, memberToBeDescribed);
            ArrayList output = (ArrayList)rc.getResult();
            Object obj = output.get(0);
            if (obj != null && obj instanceof MemberInformation) {
                CompositeResultData crd = ResultBuilder.createCompositeResultData();
                MemberInformation memberInformation = (MemberInformation)obj;
                memberInformation.setName(memberToBeDescribed.getName());
                memberInformation.setId(memberToBeDescribed.getId());
                memberInformation.setHost(memberToBeDescribed.getHost());
                memberInformation.setProcessId("" + memberToBeDescribed.getProcessId());
                CompositeResultData.SectionResultData section = crd.addSection();
                section.addData("Name", memberInformation.getName());
                section.addData("Id", memberInformation.getId());
                section.addData("Host", memberInformation.getHost());
                section.addData("Regions", StringUtils.join(memberInformation.getHostedRegions(), (char)'\n'));
                section.addData("PID", memberInformation.getProcessId());
                section.addData("Groups", memberInformation.getGroups());
                section.addData("Used Heap", memberInformation.getHeapUsage() + "M");
                section.addData("Max Heap", memberInformation.getMaxHeapSize() + "M");
                String offHeapMemorySize = memberInformation.getOffHeapMemorySize();
                if (offHeapMemorySize != null && !offHeapMemorySize.isEmpty()) {
                    section.addData("Off Heap Size", offHeapMemorySize);
                }
                section.addData("Working Dir", memberInformation.getWorkingDirPath());
                section.addData("Log file", memberInformation.getLogFilePath());
                section.addData("Locators", memberInformation.getLocators());
                if (memberInformation.isServer()) {
                    CompositeResultData.SectionResultData clientServiceSection = crd.addSection();
                    List<CacheServerInfo> csList = memberInformation.getCacheServeInfo();
                    if (csList != null) {
                        Iterator<CacheServerInfo> iters = csList.iterator();
                        clientServiceSection.setHeader("Cache Server Information");
                        while (iters.hasNext()) {
                            CacheServerInfo cacheServerInfo = iters.next();
                            clientServiceSection.addData("Server Bind", cacheServerInfo.getBindAddress());
                            clientServiceSection.addData("Server Port", cacheServerInfo.getPort());
                            clientServiceSection.addData("Running", cacheServerInfo.isRunning());
                        }
                        clientServiceSection.addData("Client Connections", memberInformation.getClientCount());
                    }
                }
                result = ResultBuilder.buildResult(crd);
            } else {
                result = ResultBuilder.createInfoResult(CliStrings.format("Information for the member \"{0}\" could not be retrieved.", new Object[]{memberNameOrId}));
            }
        }
        catch (CacheClosedException memberToBeDescribed) {
        }
        catch (Exception e) {
            result = ResultBuilder.createGemFireErrorResult(e.getMessage());
        }
        return result;
    }
}

