/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionInvocationTargetException;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.util.ArgumentRedactor;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.commands.InternalGfshCommand;
import org.apache.geode.management.internal.cli.domain.MemberConfigurationInfo;
import org.apache.geode.management.internal.cli.functions.GetMemberConfigInformationFunction;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.CompositeResultData;
import org.apache.geode.management.internal.cli.result.ErrorResultData;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.TabularResultData;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class DescribeConfigCommand
extends InternalGfshCommand {
    private final GetMemberConfigInformationFunction getMemberConfigFunction = new GetMemberConfigInformationFunction();

    @CliCommand(value={"describe config"}, help="Display configuration details of a member or members.")
    @CliMetaData(relatedTopic={"Configuration"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public Result describeConfig(@CliOption(key={"member"}, optionContext="geode.converter.all.member.idOrName:disable-string-converter", help="Name/Id of the member whose configuration will be described.", mandatory=true) String memberNameOrId, @CliOption(key={"hide-defaults"}, help="Whether to hide configuration information for properties with the default value.", unspecifiedDefaultValue="true", specifiedDefaultValue="true") boolean hideDefaults) {
        CommandResult result = null;
        try {
            ResultCollector<?, ?> rc;
            ArrayList output;
            Object obj;
            DistributedMember targetMember = null;
            if (memberNameOrId != null && !memberNameOrId.isEmpty()) {
                targetMember = this.getMember(memberNameOrId);
            }
            if ((obj = (output = (ArrayList)(rc = this.executeFunction((Function)this.getMemberConfigFunction, (Object)hideDefaults, targetMember)).getResult()).get(0)) != null && obj instanceof MemberConfigurationInfo) {
                MemberConfigurationInfo memberConfigInfo = (MemberConfigurationInfo)obj;
                CompositeResultData crd = ResultBuilder.createCompositeResultData();
                crd.setHeader(CliStrings.format("Configuration of member : \"{0}\"", (Object)memberNameOrId));
                List<String> jvmArgsList = memberConfigInfo.getJvmInputArguments();
                TabularResultData jvmInputArgs = crd.addSection().addSection().addTable();
                for (String jvmArg : jvmArgsList) {
                    jvmInputArgs.accumulate("JVM command line arguments", ArgumentRedactor.redact(jvmArg));
                }
                this.addSection(crd, memberConfigInfo.getGfePropsSetUsingApi(), "GemFire properties defined using the API");
                this.addSection(crd, memberConfigInfo.getGfePropsRuntime(), "GemFire properties defined at the runtime");
                this.addSection(crd, memberConfigInfo.getGfePropsSetFromFile(), "GemFire properties defined with the property file");
                this.addSection(crd, memberConfigInfo.getGfePropsSetWithDefaults(), "GemFire properties using default values");
                this.addSection(crd, memberConfigInfo.getCacheAttributes(), "Cache attributes");
                List<Map<String, String>> cacheServerAttributesList = memberConfigInfo.getCacheServerAttributes();
                if (cacheServerAttributesList != null && !cacheServerAttributesList.isEmpty()) {
                    CompositeResultData.SectionResultData cacheServerSection = crd.addSection();
                    cacheServerSection.setHeader("Cache-server attributes");
                    for (Map<String, String> cacheServerAttributes : cacheServerAttributesList) {
                        this.addSubSection(cacheServerSection, cacheServerAttributes);
                    }
                }
                result = ResultBuilder.buildResult(crd);
            }
        }
        catch (FunctionInvocationTargetException e) {
            result = ResultBuilder.createGemFireErrorResult(CliStrings.format("Could not execute \" {0} \", please try again ", (Object)"describe config"));
        }
        catch (Exception e) {
            ErrorResultData erd = ResultBuilder.createErrorResultData();
            erd.addLine(e.getMessage());
            result = ResultBuilder.buildResult(erd);
        }
        return result;
    }

    private void addSection(CompositeResultData crd, Map<String, String> attrMap, String headerText) {
        if (attrMap != null && !attrMap.isEmpty()) {
            CompositeResultData.SectionResultData section = crd.addSection();
            section.setHeader(headerText);
            section.addSeparator('.');
            TreeSet<String> attributes = new TreeSet<String>(attrMap.keySet());
            for (String attribute : attributes) {
                String attributeValue = attrMap.get(attribute);
                section.addData(attribute, attributeValue);
            }
        }
    }

    private void addSubSection(CompositeResultData.SectionResultData section, Map<String, String> attrMap) {
        if (!attrMap.isEmpty()) {
            CompositeResultData.SectionResultData subSection = section.addSection();
            TreeSet<String> attributes = new TreeSet<String>(attrMap.keySet());
            subSection.setHeader("");
            for (String attribute : attributes) {
                String attributeValue = attrMap.get(attribute);
                subSection.addData(attribute, attributeValue);
            }
        }
    }
}

