/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.List;
import java.util.Set;
import org.apache.geode.cache.query.IndexType;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.InternalClusterConfigurationService;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.commands.InternalGfshCommand;
import org.apache.geode.management.internal.cli.domain.IndexInfo;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.functions.CreateIndexFunction;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class CreateIndexCommand
extends InternalGfshCommand {
    private static final CreateIndexFunction createIndexFunction = new CreateIndexFunction();

    @CliCommand(value={"create index"}, help="Create an index that can be used when executing queries.")
    @CliMetaData(relatedTopic={"Region", "Data"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE, target=ResourcePermission.Target.QUERY)
    public Result createIndex(@CliOption(key={"name"}, mandatory=true, help="Name of the index to create.") String indexName, @CliOption(key={"expression"}, mandatory=true, help="Field of the region values that are referenced by the index.") String indexedExpression, @CliOption(key={"region"}, mandatory=true, optionContext="geode.converter.region.path:disable-string-converter", help="Name/Path of the region which corresponds to the \"from\" clause in a query.") String regionPath, @CliOption(key={"member", "members"}, optionContext="geode.converter.member.idOrName:disable-string-converter", help="Name/Id of the member in which the index will be created.") String[] memberNameOrID, @CliOption(key={"type"}, unspecifiedDefaultValue="range", optionContext="geode.converter.index.type:disable-enum-converter", help="Type of the index. Valid values are: range and key. Deprecated: Since Geode 1.4, hash should not be used.") IndexType indexType, @CliOption(key={"group", "groups"}, optionContext="geode.converter.member.groups:disable-string-converter", help="Group of members in which the index will be created.") String[] group) {
        Set<DistributedMember> targetMembers = this.findMembers(group, memberNameOrID);
        if (targetMembers.isEmpty()) {
            return ResultBuilder.createUserErrorResult("No Members Found");
        }
        IndexInfo indexInfo = new IndexInfo(indexName, indexedExpression, regionPath, indexType);
        List<CliFunctionResult> functionResults = this.executeAndGetFunctionResult(createIndexFunction, indexInfo, targetMembers);
        CommandResult result = ResultBuilder.buildResult(functionResults);
        XmlEntity xmlEntity = this.findXmlEntity(functionResults);
        if (xmlEntity != null) {
            this.persistClusterConfiguration(result, () -> ((InternalClusterConfigurationService)this.getConfigurationService()).addXmlEntity(xmlEntity, group));
        }
        return result;
    }
}

