/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal;

import java.io.File;
import java.net.URL;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class AgentUtil {
    private static final Logger logger = LogService.getLogger();
    public static final String ERROR_VARIABLE_NOT_SET = "The GEODE_HOME environment variable must be set!";
    private String gemfireVersion = null;

    public AgentUtil(String gemfireVersion) {
        this.gemfireVersion = gemfireVersion;
    }

    public String findWarLocation(String warFilePrefix) {
        String[] possibleFiles;
        String geodeHome = this.getGeodeHome();
        if (StringUtils.isNotBlank((String)geodeHome)) {
            for (String possibleFile : possibleFiles = new String[]{geodeHome + "/tools/Extensions/" + warFilePrefix + "-" + this.gemfireVersion + ".war", geodeHome + "/tools/Pulse/" + warFilePrefix + "-" + this.gemfireVersion + ".war", geodeHome + "/lib/" + warFilePrefix + "-" + this.gemfireVersion + ".war", geodeHome + "/tools/Extensions/" + warFilePrefix + ".war", geodeHome + "/tools/Pulse/" + warFilePrefix + ".war", geodeHome + "/lib/" + warFilePrefix + ".war"}) {
                if (!new File(possibleFile).isFile()) continue;
                logger.info(warFilePrefix + " war found: {}", (Object)possibleFile);
                return possibleFile;
            }
        }
        for (String possibleFile : possibleFiles = new String[]{warFilePrefix + "-" + this.gemfireVersion + ".war", "tools/Pulse/" + warFilePrefix + "-" + this.gemfireVersion + ".war", "tools/Extensions/" + warFilePrefix + "-" + this.gemfireVersion + ".war", "lib/" + warFilePrefix + "-" + this.gemfireVersion + ".war", warFilePrefix + ".war"}) {
            URL url = this.getClass().getClassLoader().getResource(possibleFile);
            if (url == null) continue;
            logger.info(warFilePrefix + " war found: {}", (Object)possibleFile);
            return url.getPath();
        }
        logger.warn(warFilePrefix + " war file was not found");
        return null;
    }

    public boolean isWebApplicationAvailable(String warFileLocation) {
        return StringUtils.isNotBlank((String)warFileLocation);
    }

    public boolean isWebApplicationAvailable(String ... warFileLocations) {
        for (String warFileLocation : warFileLocations) {
            if (!this.isWebApplicationAvailable(warFileLocation)) continue;
            return true;
        }
        return false;
    }

    public String getGeodeHome() {
        String geodeHome = System.getenv("GEODE_HOME");
        logger.info("GEODE_HOME:" + geodeHome);
        if (StringUtils.isBlank((String)geodeHome)) {
            geodeHome = System.getProperty("gemfire.home");
            logger.info("Reading gemfire.home System Property -> {}", (Object)geodeHome);
            if (StringUtils.isBlank((String)geodeHome)) {
                logger.info("GEODE_HOME environment variable not set; HTTP service will not start.");
                geodeHome = null;
            }
        }
        return geodeHome;
    }

    public boolean isGemfireHomeDefined() {
        String gemfireHome = this.getGeodeHome();
        return StringUtils.isNotBlank((String)gemfireHome);
    }
}

