/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.util;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.geode.internal.util.ArrayUtils;

public class ArgumentRedactor {
    public static final String redacted = "********";
    private static final List<String> tabooToContain = ArrayUtils.asList("password");
    private static final List<String> tabooForOptionToStartWith = ArrayUtils.asList("sysprop-", "javax.net.ssl", "security-");
    private static final Pattern optionWithArgumentPattern = ArgumentRedactor.getOptionWithArgumentPattern();

    private static Pattern getOptionWithArgumentPattern() {
        String spaceOrBeginningAnchor = "(?:^| )";
        String maybeLeadingWithDashDashJEquals = "(?:--J=)?";
        String oneOrTwoDashes = "--?";
        String capture_beginningBoundary = "(" + spaceOrBeginningAnchor + maybeLeadingWithDashDashJEquals + oneOrTwoDashes + ")";
        String capture_optionNameHasNoSpaces = "([^\\s=]+)";
        String boundary_lookAheadForSpaceOrEquals = "(?=[ =])";
        String capture_optionArgumentSeparator = "( *[ =] *)";
        String boundary_negativeLookAheadToPreventNextOptionAsThisArgument = "(?! *-)";
        String argumentCanBeAnythingBetweenQuotes = "\"[^\"]*\"";
        String argumentCanHaveNoSpacesWithoutQuotes = "\\S+";
        String argumentCanBeEitherOfTheAbove = "(?:" + argumentCanBeAnythingBetweenQuotes + "|" + argumentCanHaveNoSpacesWithoutQuotes + ")";
        String capture_Argument = "(" + argumentCanBeEitherOfTheAbove + ")";
        String fullPattern = capture_beginningBoundary + capture_optionNameHasNoSpaces + boundary_lookAheadForSpaceOrEquals + capture_optionArgumentSeparator + boundary_negativeLookAheadToPreventNextOptionAsThisArgument + capture_Argument;
        return Pattern.compile(fullPattern);
    }

    private ArgumentRedactor() {
    }

    public static String redact(String line, boolean permitFirstPairWithoutHyphen) {
        boolean wasPaddedWithHyphen = false;
        if (!line.trim().startsWith("-") && permitFirstPairWithoutHyphen) {
            line = "-" + line.trim();
            wasPaddedWithHyphen = true;
        }
        Matcher matcher = optionWithArgumentPattern.matcher(line);
        while (matcher.find()) {
            String option = matcher.group(2);
            if (!ArgumentRedactor.isTaboo(option)) continue;
            String leadingBoundary = matcher.group(1);
            String separator = matcher.group(3);
            String withRedaction = leadingBoundary + option + separator + redacted;
            line = line.replace(matcher.group(), withRedaction);
        }
        if (wasPaddedWithHyphen) {
            line = line.substring(1);
        }
        return line;
    }

    public static String redact(String line) {
        return ArgumentRedactor.redact(line, true);
    }

    public static String redact(List<String> args) {
        return ArgumentRedactor.redact(String.join((CharSequence)" ", args));
    }

    public static String redactArgumentIfNecessary(String option, String argument) {
        if (ArgumentRedactor.isTaboo(option)) {
            return redacted;
        }
        return argument;
    }

    static boolean isTaboo(String option) {
        if (option == null) {
            return false;
        }
        for (String taboo : tabooForOptionToStartWith) {
            if (!option.toLowerCase().startsWith(taboo) && !option.toLowerCase().startsWith("d" + taboo)) continue;
            return true;
        }
        for (String taboo : tabooToContain) {
            if (!option.toLowerCase().contains(taboo)) continue;
            return true;
        }
        return false;
    }

    public static List<String> redactEachInList(List<String> argList) {
        return argList.stream().map(ArgumentRedactor::redact).collect(Collectors.toList());
    }
}

