/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.tcp;

import java.io.EOFException;
import java.io.IOException;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.tcp.Buffers;
import org.apache.geode.internal.tcp.Connection;
import org.apache.geode.internal.tcp.MsgReader;

public class NIOMsgReader
extends MsgReader {
    private ByteBuffer nioInputBuffer;
    private final SocketChannel inputChannel;
    private int lastReadPosition;
    private int lastProcessedPosition;

    public NIOMsgReader(Connection conn, Version version) throws SocketException {
        super(conn, version);
        this.inputChannel = conn.getSocket().getChannel();
    }

    @Override
    public ByteBuffer readAtLeast(int bytes) throws IOException {
        this.ensureCapacity(bytes);
        while (this.lastReadPosition - this.lastProcessedPosition < bytes) {
            this.nioInputBuffer.limit(this.nioInputBuffer.capacity());
            this.nioInputBuffer.position(this.lastReadPosition);
            int bytesRead = this.inputChannel.read(this.nioInputBuffer);
            if (bytesRead < 0) {
                throw new EOFException();
            }
            this.lastReadPosition = this.nioInputBuffer.position();
        }
        this.nioInputBuffer.limit(this.lastProcessedPosition + bytes);
        this.nioInputBuffer.position(this.lastProcessedPosition);
        this.lastProcessedPosition = this.nioInputBuffer.limit();
        return this.nioInputBuffer;
    }

    protected void ensureCapacity(int bufferSize) {
        if (this.nioInputBuffer != null && this.nioInputBuffer.capacity() > bufferSize) {
            if (this.nioInputBuffer.capacity() - this.lastProcessedPosition < bufferSize) {
                this.nioInputBuffer.limit(this.lastReadPosition);
                this.nioInputBuffer.position(this.lastProcessedPosition);
                this.nioInputBuffer.compact();
                this.lastReadPosition = this.nioInputBuffer.position();
                this.lastProcessedPosition = 0;
            }
            return;
        }
        if (this.nioInputBuffer == null) {
            int allocSize = this.conn.getReceiveBufferSize();
            if (allocSize == -1) {
                allocSize = this.conn.getConduit().tcpBufferSize;
            }
            if (allocSize > bufferSize) {
                bufferSize = allocSize;
            }
        }
        ByteBuffer oldBuffer = this.nioInputBuffer;
        this.nioInputBuffer = Buffers.acquireReceiveBuffer(bufferSize, this.getStats());
        if (oldBuffer != null) {
            oldBuffer.limit(this.lastReadPosition);
            oldBuffer.position(this.lastProcessedPosition);
            this.nioInputBuffer.put(oldBuffer);
            this.lastReadPosition = this.nioInputBuffer.position();
            this.lastProcessedPosition = 0;
            Buffers.releaseReceiveBuffer(oldBuffer, this.getStats());
        }
    }

    @Override
    public void close() {
        ByteBuffer tmp = this.nioInputBuffer;
        if (tmp != null) {
            this.nioInputBuffer = null;
            Buffers.releaseReceiveBuffer(tmp, this.getStats());
        }
    }
}

