/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.sequencelog;

import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.cache.CachedDeserializable;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PlaceHolderDiskRegion;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.entries.DiskEntry;
import org.apache.geode.internal.cache.persistence.DiskStoreID;
import org.apache.geode.internal.offheap.StoredObject;
import org.apache.geode.internal.sequencelog.GraphType;
import org.apache.geode.internal.sequencelog.SequenceLogger;
import org.apache.geode.internal.sequencelog.SequenceLoggerImpl;

public class EntryLogger {
    private static final SequenceLogger GRAPH_LOGGER = SequenceLoggerImpl.getInstance();
    private static ThreadLocal<String> SOURCE = new ThreadLocal();
    private static ThreadLocal<String> SOURCE_TYPE = new ThreadLocal();
    public static final String TRACK_VALUES_PROPERTY = "gemfire.EntryLogger.TRACK_VALUES";
    private static final boolean TRACK_VALUES = Boolean.getBoolean("gemfire.EntryLogger.TRACK_VALUES");

    public static void clearSource() {
        if (EntryLogger.isEnabled()) {
            SOURCE.set(null);
            SOURCE_TYPE.set(null);
        }
    }

    public static void setSource(Object source, String sourceType) {
        if (EntryLogger.isEnabled()) {
            SOURCE.set(source.toString());
            SOURCE_TYPE.set(sourceType);
        }
    }

    public static void logPut(EntryEventImpl event) {
        if (EntryLogger.isEnabled()) {
            GRAPH_LOGGER.logTransition(GraphType.KEY, EntryLogger.getGraphName(event), EntryLogger.getEdgeName("put"), EntryLogger.processValue(event.getRawNewValue()), EntryLogger.getSource(), EntryLogger.getDest());
        }
    }

    private static String getEdgeName(String transition) {
        String sourceType = SOURCE_TYPE.get();
        sourceType = sourceType == null ? "" : sourceType + " ";
        return sourceType + transition;
    }

    public static void logInvalidate(EntryEventImpl event) {
        if (EntryLogger.isEnabled()) {
            String invalidationType = event.getOperation().isLocal() ? "local_invalid" : "invalid";
            GRAPH_LOGGER.logTransition(GraphType.KEY, EntryLogger.getGraphName(event), EntryLogger.getEdgeName("invalidate"), invalidationType, EntryLogger.getSource(), EntryLogger.getDest());
        }
    }

    public static void logDestroy(EntryEventImpl event) {
        if (EntryLogger.isEnabled()) {
            GRAPH_LOGGER.logTransition(GraphType.KEY, EntryLogger.getGraphName(event), EntryLogger.getEdgeName("destroy"), "destroyed", EntryLogger.getSource(), EntryLogger.getDest());
        }
    }

    public static void logRecovery(Object owner, Object key, DiskEntry.RecoveredEntry value) {
        if (EntryLogger.isEnabled()) {
            GRAPH_LOGGER.logTransition(GraphType.KEY, EntryLogger.getGraphNameFromOwner(owner, key), "recovery", EntryLogger.processValue(value.getValue()), EntryLogger.getSource(), EntryLogger.getDest());
        }
    }

    public static void logPersistPut(String name, Object key, DiskStoreID diskStoreID) {
        if (EntryLogger.isEnabled()) {
            GRAPH_LOGGER.logTransition(GraphType.KEY, EntryLogger.getGraphName(name, key), "persist", "persisted", EntryLogger.getDest(), diskStoreID);
        }
    }

    public static void logPersistDestroy(String name, Object key, DiskStoreID diskStoreID) {
        if (EntryLogger.isEnabled()) {
            GRAPH_LOGGER.logTransition(GraphType.KEY, EntryLogger.getGraphName(name, key), "persist_destroy", "destroy", EntryLogger.getDest(), diskStoreID);
        }
    }

    public static void logInitialImagePut(Object owner, Object key, Object newValue) {
        if (EntryLogger.isEnabled()) {
            GRAPH_LOGGER.logTransition(GraphType.KEY, EntryLogger.getGraphNameFromOwner(owner, key), "GII", EntryLogger.processValue(newValue), EntryLogger.getSource(), EntryLogger.getDest());
        }
    }

    public static void logTXDestroy(Object owner, Object key) {
        if (EntryLogger.isEnabled()) {
            GRAPH_LOGGER.logTransition(GraphType.KEY, EntryLogger.getGraphNameFromOwner(owner, key), EntryLogger.getEdgeName("txdestroy"), "destroyed", EntryLogger.getSource(), EntryLogger.getDest());
        }
    }

    public static void logTXInvalidate(Object owner, Object key) {
        if (EntryLogger.isEnabled()) {
            GRAPH_LOGGER.logTransition(GraphType.KEY, EntryLogger.getGraphNameFromOwner(owner, key), EntryLogger.getEdgeName("txinvalidate"), "invalid", EntryLogger.getSource(), EntryLogger.getDest());
        }
    }

    public static void logTXPut(Object owner, Object key, Object nv) {
        if (EntryLogger.isEnabled()) {
            GRAPH_LOGGER.logTransition(GraphType.KEY, EntryLogger.getGraphNameFromOwner(owner, key), EntryLogger.getEdgeName("txput"), EntryLogger.processValue(nv), EntryLogger.getSource(), EntryLogger.getDest());
        }
    }

    public static boolean isEnabled() {
        return GRAPH_LOGGER.isEnabled(GraphType.KEY);
    }

    private static Object getDest() {
        return InternalDistributedSystem.getAnyInstance().getMemberId();
    }

    private static Object getSource() {
        String source = SOURCE.get();
        if (source == null) {
            source = InternalDistributedSystem.getAnyInstance().getMemberId();
        }
        return source;
    }

    private static Object processValue(Object rawNewValue) {
        if (rawNewValue != null && Token.isInvalid(rawNewValue)) {
            return "invalid";
        }
        if (!TRACK_VALUES) {
            return "present";
        }
        if (rawNewValue instanceof StoredObject) {
            return "off-heap";
        }
        if (rawNewValue instanceof CachedDeserializable) {
            rawNewValue = ((CachedDeserializable)rawNewValue).getDeserializedForReading();
        }
        if (rawNewValue instanceof byte[]) {
            return "serialized:" + EntryLogger.hash((byte[])rawNewValue);
        }
        return rawNewValue;
    }

    private static Object hash(byte[] rawNewValue) {
        int hash = 17;
        int length = rawNewValue.length;
        if (length > 100) {
            length = 100;
        }
        for (int i = 0; i < length; ++i) {
            hash = 31 * hash + rawNewValue[i];
        }
        return hash;
    }

    private static String getGraphName(EntryEventImpl event) {
        return EntryLogger.getGraphName(event.getRegion().getFullPath(), event.getKey());
    }

    private static String getGraphNameFromOwner(Object owner, Object key) {
        String ownerName = owner instanceof LocalRegion ? ((LocalRegion)owner).getFullPath() : (owner instanceof PlaceHolderDiskRegion ? ((PlaceHolderDiskRegion)owner).getName() : owner.toString());
        return EntryLogger.getGraphName(ownerName, key);
    }

    private static String getGraphName(String ownerName, Object key) {
        return ownerName + ":" + key;
    }

    public static void logUpdateEntryVersion(EntryEventImpl event) {
        if (EntryLogger.isEnabled()) {
            GRAPH_LOGGER.logTransition(GraphType.KEY, EntryLogger.getGraphName(event), EntryLogger.getEdgeName("update-version"), "version-updated", EntryLogger.getSource(), EntryLogger.getDest());
        }
    }
}

