/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.security.shiro;

import java.security.Principal;
import java.util.Collections;
import java.util.Properties;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.remote.JMXAuthenticator;
import javax.management.remote.JMXConnectionNotification;
import javax.management.remote.JMXPrincipal;
import javax.security.auth.Subject;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.internal.security.shiro.ShiroPrincipal;
import org.apache.geode.security.AuthenticationFailedException;

public class JMXShiroAuthenticator
implements JMXAuthenticator,
NotificationListener {
    private final SecurityService securityService;

    public JMXShiroAuthenticator(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Override
    public Subject authenticate(Object credentials) {
        String username = null;
        Properties credProps = new Properties();
        if (credentials instanceof Properties) {
            credProps = (Properties)credentials;
            username = credProps.getProperty("security-username");
        } else if (credentials instanceof String[]) {
            String[] aCredentials = (String[])credentials;
            username = aCredentials[0];
            credProps.setProperty("security-username", aCredentials[0]);
            credProps.setProperty("security-password", aCredentials[1]);
        } else {
            throw new AuthenticationFailedException("Missing Credentials. Please supply username/password.");
        }
        org.apache.shiro.subject.Subject shiroSubject = this.securityService.login(credProps);
        Principal principal = shiroSubject == null ? new JMXPrincipal(username) : new ShiroPrincipal(shiroSubject);
        return new Subject(true, Collections.singleton(principal), Collections.emptySet(), Collections.emptySet());
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        JMXConnectionNotification cxNotification;
        String type;
        if (notification instanceof JMXConnectionNotification && "jmx.remote.connection.closed".equals(type = (cxNotification = (JMXConnectionNotification)notification).getType())) {
            this.securityService.logout();
        }
    }
}

