/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.process;

import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.Validate;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

class ControlFileWatchdog
implements Runnable {
    private static final Logger logger = LogService.getLogger();
    private static final long STOP_TIMEOUT_MILLIS = 60000L;
    private static final long LOOP_INTERVAL_MILLIS = 1000L;
    private final File directory;
    private final File file;
    private final ControlRequestHandler requestHandler;
    private final boolean stopAfterRequest;
    private Thread thread;
    private boolean alive;

    ControlFileWatchdog(File directory, String fileName, ControlRequestHandler requestHandler, boolean stopAfterRequest) {
        Validate.notNull((Object)directory, (String)("Invalid directory '" + directory + "' specified"));
        Validate.notEmpty((String)fileName, (String)("Invalid fileName '" + fileName + "' specified"));
        Validate.notNull((Object)requestHandler, (String)("Invalid requestHandler '" + requestHandler + "' specified"));
        this.directory = directory;
        this.file = new File(directory, fileName);
        this.requestHandler = requestHandler;
        this.stopAfterRequest = stopAfterRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (this.isAlive()) {
                this.doWork();
            }
        }
        finally {
            ControlFileWatchdog controlFileWatchdog = this;
            synchronized (controlFileWatchdog) {
                this.alive = false;
            }
        }
    }

    private void doWork() {
        try {
            if (this.file.exists()) {
                try {
                    this.handleRequest();
                }
                finally {
                    if (this.stopAfterRequest) {
                        this.stopMe();
                    }
                }
            }
            Thread.sleep(1000L);
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
        catch (IOException ignored) {
            logger.error("Unable to control process with {}. Please add tools.jar from JDK to classpath for improved process control.", (Object)this.file);
        }
    }

    private void handleRequest() throws IOException {
        try {
            this.requestHandler.handleRequest();
        }
        finally {
            try {
                this.file.delete();
            }
            catch (SecurityException e) {
                logger.warn("Unable to delete {}", (Object)this.file, (Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start() {
        ControlFileWatchdog controlFileWatchdog = this;
        synchronized (controlFileWatchdog) {
            if (this.thread == null) {
                this.thread = new Thread((Runnable)this, this.createThreadName());
                this.thread.setDaemon(true);
                this.alive = true;
                this.thread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() throws InterruptedException {
        Thread stopping = null;
        ControlFileWatchdog controlFileWatchdog = this;
        synchronized (controlFileWatchdog) {
            if (this.thread != null) {
                this.alive = false;
                if (this.thread != Thread.currentThread()) {
                    this.thread.interrupt();
                    stopping = this.thread;
                }
                this.thread = null;
            }
        }
        if (stopping != null) {
            stopping.join(60000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isAlive() {
        ControlFileWatchdog controlFileWatchdog = this;
        synchronized (controlFileWatchdog) {
            return this.alive;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopMe() {
        ControlFileWatchdog controlFileWatchdog = this;
        synchronized (controlFileWatchdog) {
            if (this.thread != null) {
                this.alive = false;
                this.thread = null;
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append('@').append(System.identityHashCode(this)).append('{');
        sb.append("directory=").append(this.directory);
        sb.append(", file=").append(this.file);
        sb.append(", alive=").append(this.alive);
        sb.append(", stopAfterRequest=").append(this.stopAfterRequest);
        return sb.append('}').toString();
    }

    private String createThreadName() {
        return this.getClass().getSimpleName() + '@' + Integer.toHexString(this.hashCode()) + " monitoring " + this.file.getName();
    }

    static interface ControlRequestHandler {
        public void handleRequest() throws IOException;
    }
}

