/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.offheap;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.geode.internal.offheap.RefCountChangeInfo;
import org.apache.geode.internal.offheap.ReferenceCountHelperImpl;

public class ReferenceCountHelper {
    public static final String TRACK_OFFHEAP_REFERENCES = "gemfire.trackOffHeapRefCounts";
    public static final String TRACK_OFFHEAP_FREES = "gemfire.trackOffHeapFreedRefCounts";
    private static final ReferenceCountHelperImpl inst = new ReferenceCountHelperImpl(Boolean.getBoolean("gemfire.trackOffHeapRefCounts"), Boolean.getBoolean("gemfire.trackOffHeapFreedRefCounts"));

    private ReferenceCountHelper() {
    }

    static ReferenceCountHelperImpl getInstance() {
        return inst;
    }

    public static boolean trackReferenceCounts() {
        return ReferenceCountHelper.getInstance().trackReferenceCounts();
    }

    public static boolean trackFreedReferenceCounts() {
        return ReferenceCountHelper.getInstance().trackFreedReferenceCounts();
    }

    public static void setReferenceCountOwner(Object owner) {
        ReferenceCountHelper.getInstance().setReferenceCountOwner(owner);
    }

    public static Object createReferenceCountOwner() {
        return ReferenceCountHelper.getInstance().createReferenceCountOwner();
    }

    public static void skipRefCountTracking() {
        ReferenceCountHelper.getInstance().skipRefCountTracking();
    }

    public static boolean isRefCountTracking() {
        return ReferenceCountHelper.getInstance().isRefCountTracking();
    }

    public static void unskipRefCountTracking() {
        ReferenceCountHelper.getInstance().unskipRefCountTracking();
    }

    public static List<RefCountChangeInfo> getRefCountInfo(long address) {
        return ReferenceCountHelper.getInstance().getRefCountInfo(address);
    }

    static void refCountChanged(Long address, boolean decRefCount, int rc) {
        ReferenceCountHelper.getInstance().refCountChanged(address, decRefCount, rc);
    }

    static void freeRefCountInfo(Long address) {
        ReferenceCountHelper.getInstance().freeRefCountInfo(address);
    }

    static Object getReferenceCountOwner() {
        return ReferenceCountHelper.getInstance().getReferenceCountOwner();
    }

    static AtomicInteger getReenterCount() {
        return ReferenceCountHelper.getInstance().getReenterCount();
    }

    public static List<RefCountChangeInfo> getFreeRefCountInfo(long address) {
        return ReferenceCountHelper.getInstance().getFreeRefCountInfo(address);
    }

    static List<RefCountChangeInfo> peekRefCountInfo(long address) {
        return ReferenceCountHelper.getInstance().peekRefCountInfo(address);
    }
}

