/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.offheap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.Region;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PartitionedRegionDataStore;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.offheap.FreeListManager;
import org.apache.geode.internal.offheap.LifecycleListener;
import org.apache.geode.internal.offheap.MemoryAllocator;
import org.apache.geode.internal.offheap.MemoryBlock;
import org.apache.geode.internal.offheap.MemoryBlockNode;
import org.apache.geode.internal.offheap.MemoryInspector;
import org.apache.geode.internal.offheap.MemoryInspectorImpl;
import org.apache.geode.internal.offheap.MemoryUsageListener;
import org.apache.geode.internal.offheap.OffHeapMemoryStats;
import org.apache.geode.internal.offheap.OffHeapRegionEntryHelper;
import org.apache.geode.internal.offheap.OffHeapStoredObject;
import org.apache.geode.internal.offheap.OffHeapStoredObjectWithHeapForm;
import org.apache.geode.internal.offheap.OutOfOffHeapMemoryListener;
import org.apache.geode.internal.offheap.ReferenceCountHelper;
import org.apache.geode.internal.offheap.Slab;
import org.apache.geode.internal.offheap.SlabFactory;
import org.apache.geode.internal.offheap.SlabImpl;
import org.apache.geode.internal.offheap.StoredObject;
import org.apache.geode.internal.offheap.TinyStoredObject;
import org.apache.logging.log4j.Logger;

public class MemoryAllocatorImpl
implements MemoryAllocator {
    static final Logger logger = LogService.getLogger();
    public static final String FREE_OFF_HEAP_MEMORY_PROPERTY = "gemfire.free-off-heap-memory";
    private volatile OffHeapMemoryStats stats;
    private volatile OutOfOffHeapMemoryListener ooohml;
    public final FreeListManager freeList;
    private MemoryInspector memoryInspector;
    private volatile MemoryUsageListener[] memoryUsageListeners = new MemoryUsageListener[0];
    private static MemoryAllocatorImpl singleton = null;
    private static final boolean DO_EXPENSIVE_VALIDATION = Boolean.getBoolean("gemfire.OFF_HEAP_DO_EXPENSIVE_VALIDATION");
    private final AtomicBoolean closed = new AtomicBoolean();

    OutOfOffHeapMemoryListener getOutOfOffHeapMemoryListener() {
        return this.ooohml;
    }

    public static MemoryAllocatorImpl getAllocator() {
        MemoryAllocatorImpl result = singleton;
        if (result == null) {
            throw new CacheClosedException("Off Heap memory allocator does not exist.");
        }
        return result;
    }

    public static MemoryAllocator create(OutOfOffHeapMemoryListener ooohml, OffHeapMemoryStats stats, int slabCount, long offHeapMemorySize, long maxSlabSize) {
        return MemoryAllocatorImpl.create(ooohml, stats, slabCount, offHeapMemorySize, maxSlabSize, null, new SlabFactory(){

            @Override
            public Slab create(int size) {
                return new SlabImpl(size);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MemoryAllocatorImpl create(OutOfOffHeapMemoryListener ooohml, OffHeapMemoryStats stats, int slabCount, long offHeapMemorySize, long maxSlabSize, Slab[] slabs, SlabFactory slabFactory) {
        MemoryAllocatorImpl result = singleton;
        boolean created = false;
        try {
            if (result != null) {
                result.reuse(ooohml, stats, offHeapMemorySize, slabs);
                logger.info("Reusing {}  bytes of off-heap memory. The maximum size of a single off-heap object is {}  bytes.", (Object)result.getTotalMemory(), (Object)result.freeList.getLargestSlabSize());
                created = true;
                LifecycleListener.invokeAfterReuse(result);
            } else {
                if (slabs == null) {
                    logger.info("Allocating {} bytes of off-heap memory. The maximum size of a single off-heap object is {} bytes.", (Object)offHeapMemorySize, (Object)maxSlabSize);
                    slabs = new SlabImpl[slabCount];
                    long uncreatedMemory = offHeapMemorySize;
                    for (int i = 0; i < slabCount; ++i) {
                        try {
                            if (uncreatedMemory >= maxSlabSize) {
                                slabs[i] = slabFactory.create((int)maxSlabSize);
                                uncreatedMemory -= maxSlabSize;
                                continue;
                            }
                            slabs[i] = slabFactory.create((int)uncreatedMemory);
                            continue;
                        }
                        catch (OutOfMemoryError err) {
                            if (i > 0) {
                                logger.error("Off-heap memory creation failed after successfully allocating {} bytes of off-heap memory.", (Object)((long)i * maxSlabSize));
                            }
                            for (int j = 0; j < i; ++j) {
                                if (slabs[j] == null) continue;
                                slabs[j].free();
                            }
                            throw err;
                        }
                    }
                }
                singleton = result = new MemoryAllocatorImpl(ooohml, stats, slabs);
                LifecycleListener.invokeAfterCreate(result);
                created = true;
            }
        }
        finally {
            if (!created) {
                if (stats != null) {
                    stats.close();
                }
                if (ooohml != null) {
                    ooohml.close();
                }
            }
        }
        return result;
    }

    static MemoryAllocatorImpl createForUnitTest(OutOfOffHeapMemoryListener ooohml, OffHeapMemoryStats stats, int slabCount, long offHeapMemorySize, long maxSlabSize, SlabFactory memChunkFactory) {
        return MemoryAllocatorImpl.create(ooohml, stats, slabCount, offHeapMemorySize, maxSlabSize, null, memChunkFactory);
    }

    public static MemoryAllocatorImpl createForUnitTest(OutOfOffHeapMemoryListener oooml, OffHeapMemoryStats stats, Slab[] slabs) {
        int slabCount = 0;
        long offHeapMemorySize = 0L;
        long maxSlabSize = 0L;
        if (slabs != null) {
            slabCount = slabs.length;
            for (int i = 0; i < slabCount; ++i) {
                int slabSize = slabs[i].getSize();
                offHeapMemorySize += (long)slabSize;
                if ((long)slabSize <= maxSlabSize) continue;
                maxSlabSize = slabSize;
            }
        }
        return MemoryAllocatorImpl.create(oooml, stats, slabCount, offHeapMemorySize, maxSlabSize, slabs, null);
    }

    private void reuse(OutOfOffHeapMemoryListener oooml, OffHeapMemoryStats newStats, long offHeapMemorySize, Slab[] slabs) {
        if (this.isClosed()) {
            throw new IllegalStateException("Can not reuse a closed off-heap memory manager.");
        }
        if (oooml == null) {
            throw new IllegalArgumentException("OutOfOffHeapMemoryListener is null");
        }
        if (this.getTotalMemory() != offHeapMemorySize) {
            logger.warn("Using {} bytes of existing off-heap memory instead of the requested {}.", (Object)this.getTotalMemory(), (Object)offHeapMemorySize);
        }
        if (!this.freeList.okToReuse(slabs)) {
            throw new IllegalStateException("attempted to reuse existing off-heap memory even though new off-heap memory was allocated");
        }
        this.ooohml = oooml;
        newStats.initialize(this.stats);
        this.stats = newStats;
    }

    private MemoryAllocatorImpl(OutOfOffHeapMemoryListener oooml, OffHeapMemoryStats stats, Slab[] slabs) {
        if (oooml == null) {
            throw new IllegalArgumentException("OutOfOffHeapMemoryListener is null");
        }
        this.ooohml = oooml;
        this.stats = stats;
        this.stats.setFragments(slabs.length);
        this.stats.setLargestFragment(slabs[0].getSize());
        this.freeList = new FreeListManager(this, slabs);
        this.memoryInspector = new MemoryInspectorImpl(this.freeList);
        this.stats.incMaxMemory(this.freeList.getTotalMemory());
        this.stats.incFreeMemory(this.freeList.getTotalMemory());
    }

    public List<OffHeapStoredObject> getLostChunks(InternalCache cache) {
        List<OffHeapStoredObject> liveChunks = this.freeList.getLiveChunks();
        List<OffHeapStoredObject> regionChunks = this.getRegionLiveChunks(cache);
        HashSet<OffHeapStoredObject> liveChunksSet = new HashSet<OffHeapStoredObject>(liveChunks);
        HashSet<OffHeapStoredObject> regionChunksSet = new HashSet<OffHeapStoredObject>(regionChunks);
        liveChunksSet.removeAll(regionChunksSet);
        return new ArrayList<OffHeapStoredObject>(liveChunksSet);
    }

    private List<OffHeapStoredObject> getRegionLiveChunks(InternalCache cache) {
        ArrayList<OffHeapStoredObject> result = new ArrayList<OffHeapStoredObject>();
        if (cache != null) {
            for (Region<?, ?> rr : cache.rootRegions()) {
                this.getRegionLiveChunks(rr, result);
                Iterator<Region<?, ?>> srIt = rr.subregions(true).iterator();
                while (srIt.hasNext()) {
                    this.getRegionLiveChunks(srIt.next(), result);
                }
            }
        }
        return result;
    }

    private void getRegionLiveChunks(Region<?, ?> r, List<OffHeapStoredObject> result) {
        if (r.getAttributes().getOffHeap()) {
            if (r instanceof PartitionedRegion) {
                Set<BucketRegion> brs;
                PartitionedRegionDataStore prs = ((PartitionedRegion)r).getDataStore();
                if (prs != null && (brs = prs.getAllLocalBucketRegions()) != null) {
                    for (BucketRegion br : brs) {
                        if (br == null || br.isDestroyed()) continue;
                        this.basicGetRegionLiveChunks(br, result);
                    }
                }
            } else {
                this.basicGetRegionLiveChunks((InternalRegion)r, result);
            }
        }
    }

    private void basicGetRegionLiveChunks(InternalRegion r, List<OffHeapStoredObject> result) {
        for (Object key : r.keySet()) {
            Object value;
            RegionEntry re = r.getRegionEntry(key);
            if (re == null || !((value = re.getValue()) instanceof OffHeapStoredObject)) continue;
            result.add((OffHeapStoredObject)value);
        }
    }

    private OffHeapStoredObject allocateOffHeapStoredObject(int size) {
        OffHeapStoredObject result = this.freeList.allocate(size);
        int resultSize = result.getSize();
        this.stats.incObjects(1);
        this.stats.incUsedMemory(resultSize);
        this.stats.incFreeMemory(-resultSize);
        this.notifyListeners();
        if (ReferenceCountHelper.trackReferenceCounts()) {
            ReferenceCountHelper.refCountChanged(result.getAddress(), false, 1);
        }
        return result;
    }

    @Override
    public StoredObject allocate(int size) {
        OffHeapStoredObject result = this.allocateOffHeapStoredObject(size);
        return result;
    }

    public static void debugLog(String msg, boolean logStack) {
        if (logStack) {
            logger.info(msg, (Throwable)new RuntimeException(msg));
        } else {
            logger.info(msg);
        }
    }

    @Override
    public StoredObject allocateAndInitialize(byte[] v, boolean isSerialized, boolean isCompressed) {
        return this.allocateAndInitialize(v, isSerialized, isCompressed, null);
    }

    @Override
    public StoredObject allocateAndInitialize(byte[] v, boolean isSerialized, boolean isCompressed, byte[] originalHeapData) {
        long addr = OffHeapRegionEntryHelper.encodeDataAsAddress(v, isSerialized, isCompressed);
        if (addr != 0L) {
            return new TinyStoredObject(addr);
        }
        OffHeapStoredObject result = this.allocateOffHeapStoredObject(v.length);
        result.setSerializedValue(v);
        result.setSerialized(isSerialized);
        result.setCompressed(isCompressed);
        if (originalHeapData != null) {
            result = new OffHeapStoredObjectWithHeapForm(result, originalHeapData);
        }
        return result;
    }

    @Override
    public long getFreeMemory() {
        return this.freeList.getFreeMemory();
    }

    @Override
    public long getUsedMemory() {
        return this.freeList.getUsedMemory();
    }

    @Override
    public long getTotalMemory() {
        return this.freeList.getTotalMemory();
    }

    @Override
    public void close() {
        try {
            LifecycleListener.invokeBeforeClose(this);
        }
        finally {
            this.ooohml.close();
            if (Boolean.getBoolean(FREE_OFF_HEAP_MEMORY_PROPERTY)) {
                this.realClose();
            }
        }
    }

    public static void freeOffHeapMemory() {
        MemoryAllocatorImpl ma = singleton;
        if (ma != null) {
            ma.realClose();
        }
    }

    private void realClose() {
        if (this.setClosed()) {
            this.freeList.freeSlabs();
            this.stats.close();
            singleton = null;
        }
    }

    private boolean isClosed() {
        return this.closed.get();
    }

    private boolean setClosed() {
        return this.closed.compareAndSet(false, true);
    }

    FreeListManager getFreeListManager() {
        return this.freeList;
    }

    int findSlab(long addr) {
        return this.freeList.findSlab(addr);
    }

    @Override
    public OffHeapMemoryStats getStats() {
        return this.stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMemoryUsageListener(MemoryUsageListener listener) {
        MemoryUsageListener[] memoryUsageListenerArray = this.memoryUsageListeners;
        synchronized (this.memoryUsageListeners) {
            MemoryUsageListener[] newMemoryUsageListeners = Arrays.copyOf(this.memoryUsageListeners, this.memoryUsageListeners.length + 1);
            newMemoryUsageListeners[this.memoryUsageListeners.length] = listener;
            this.memoryUsageListeners = newMemoryUsageListeners;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMemoryUsageListener(MemoryUsageListener listener) {
        MemoryUsageListener[] memoryUsageListenerArray = this.memoryUsageListeners;
        synchronized (this.memoryUsageListeners) {
            int listenerIndex = -1;
            for (int i = 0; i < this.memoryUsageListeners.length; ++i) {
                if (this.memoryUsageListeners[i] != listener) continue;
                listenerIndex = i;
                break;
            }
            if (listenerIndex != -1) {
                MemoryUsageListener[] newMemoryUsageListeners = new MemoryUsageListener[this.memoryUsageListeners.length - 1];
                System.arraycopy(this.memoryUsageListeners, 0, newMemoryUsageListeners, 0, listenerIndex);
                System.arraycopy(this.memoryUsageListeners, listenerIndex + 1, newMemoryUsageListeners, listenerIndex, this.memoryUsageListeners.length - listenerIndex - 1);
                this.memoryUsageListeners = newMemoryUsageListeners;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    void notifyListeners() {
        MemoryUsageListener[] savedListeners = this.memoryUsageListeners;
        if (savedListeners.length == 0) {
            return;
        }
        long bytesUsed = this.getUsedMemory();
        for (int i = 0; i < savedListeners.length; ++i) {
            savedListeners[i].updateMemoryUsed(bytesUsed);
        }
    }

    static void validateAddress(long addr) {
        MemoryAllocatorImpl.validateAddressAndSize(addr, -1);
    }

    static void validateAddressAndSize(long addr, int size) {
        if ((addr & 7L) != 0L) {
            StringBuilder sb = new StringBuilder();
            sb.append("address was not 8 byte aligned: 0x").append(Long.toString(addr, 16));
            MemoryAllocatorImpl ma = singleton;
            if (ma != null) {
                sb.append(". Valid addresses must be in one of the following ranges: ");
                ma.freeList.getSlabDescriptions(sb);
            }
            throw new IllegalStateException(sb.toString());
        }
        if (addr >= 0L && addr < 1024L) {
            throw new IllegalStateException("addr was smaller than expected 0x" + addr);
        }
        MemoryAllocatorImpl.validateAddressAndSizeWithinSlab(addr, size, DO_EXPENSIVE_VALIDATION);
    }

    static void validateAddressAndSizeWithinSlab(long addr, int size, boolean doExpensiveValidation) {
        MemoryAllocatorImpl ma;
        if (doExpensiveValidation && (ma = singleton) != null && !ma.freeList.validateAddressAndSizeWithinSlab(addr, size)) {
            throw new IllegalStateException(" address 0x" + Long.toString(addr, 16) + " does not address the original slab memory");
        }
    }

    public synchronized List<MemoryBlock> getOrphans(InternalCache cache) {
        List<OffHeapStoredObject> liveChunks = this.freeList.getLiveChunks();
        List<OffHeapStoredObject> regionChunks = this.getRegionLiveChunks(cache);
        liveChunks.removeAll(regionChunks);
        ArrayList<MemoryBlock> orphans = new ArrayList<MemoryBlock>();
        for (OffHeapStoredObject chunk : liveChunks) {
            orphans.add(new MemoryBlockNode(this, chunk));
        }
        Collections.sort(orphans, new Comparator<MemoryBlock>(){

            @Override
            public int compare(MemoryBlock o1, MemoryBlock o2) {
                return Long.valueOf(o1.getAddress()).compareTo(o2.getAddress());
            }
        });
        return orphans;
    }

    @Override
    public MemoryInspector getMemoryInspector() {
        return this.memoryInspector;
    }
}

