/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.lang;

public abstract class ThrowableUtils {
    public static Throwable getRootCause(Throwable throwable) {
        Throwable cause;
        if (throwable.getCause() == null) {
            return throwable;
        }
        while ((cause = throwable.getCause()) != null) {
            throwable = cause;
        }
        return throwable;
    }

    public static boolean hasCauseType(Throwable throwable, Class<? extends Throwable> causeClass) {
        Throwable cause;
        if (causeClass.isInstance(throwable)) {
            return true;
        }
        while ((cause = throwable.getCause()) != null) {
            throwable = cause;
            if (!causeClass.isInstance(throwable)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasCauseMessage(Throwable throwable, String message) {
        Throwable cause;
        if (throwable.getMessage().contains(message)) {
            return true;
        }
        while ((cause = throwable.getCause()) != null) {
            throwable = cause;
            if (!throwable.getMessage().contains(message)) continue;
            return true;
        }
        return false;
    }
}

