/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.lang;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.geode.internal.cache.CachedDeserializable;
import org.apache.geode.internal.cache.Token;

@Deprecated
public class StringUtils
extends org.apache.commons.lang.StringUtils {
    public static final String COMMA_DELIMITER = ",";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String SPACE = " ";
    private static final int MAX_ARRAY_ELEMENTS_TO_CONVERT = Integer.getInteger("StringUtils.MAX_ARRAY_ELEMENTS_TO_CONVERT", 16);

    public static String nullifyIfBlank(String value) {
        return StringUtils.isBlank((String)value) ? null : value;
    }

    public static String getDigitsOnly(String value) {
        StringBuilder buffer = new StringBuilder();
        if (value != null) {
            for (char chr : value.toCharArray()) {
                if (!Character.isDigit(chr)) continue;
                buffer.append(chr);
            }
        }
        return buffer.toString();
    }

    public static String defaultString(Object value, String defaultValue) {
        return value == null ? defaultValue : value.toString();
    }

    public static String defaultString(Object value) {
        return value == null ? "" : value.toString();
    }

    public static String wrap(String line, int widthInCharacters, String indent) {
        StringBuilder buffer = new StringBuilder();
        int lineCount = 1;
        indent = StringUtils.defaultString((String)indent);
        while (line.length() > widthInCharacters) {
            int spaceIndex = line.substring(0, widthInCharacters).lastIndexOf(SPACE);
            buffer.append(lineCount++ > 1 ? indent : "");
            buffer.append(line.substring(0, spaceIndex));
            buffer.append(LINE_SEPARATOR);
            line = line.substring(spaceIndex + 1);
        }
        buffer.append(lineCount > 1 ? indent : "");
        buffer.append(line);
        return buffer.toString();
    }

    public static String forceToString(Object o) {
        try {
            return StringUtils.objectToString(o, true, MAX_ARRAY_ELEMENTS_TO_CONVERT);
        }
        catch (RuntimeException ex) {
            return "Conversion to a string failed because " + ex;
        }
    }

    public static String objectToString(Object o, boolean convertArrayContents, int maxArrayElements) {
        if (o == null || o == Token.NOT_AVAILABLE) {
            return "null";
        }
        if (o instanceof CachedDeserializable) {
            CachedDeserializable cd = (CachedDeserializable)o;
            return cd.getStringForm();
        }
        if (convertArrayContents && o.getClass().isArray()) {
            Class<?> eClass = o.getClass();
            if (eClass == byte[].class) {
                return StringUtils.arrayToString((byte[])o, maxArrayElements);
            }
            if (eClass == boolean[].class) {
                return StringUtils.arrayToString((boolean[])o, maxArrayElements);
            }
            if (eClass == char[].class) {
                return StringUtils.arrayToString((char[])o, maxArrayElements);
            }
            if (eClass == short[].class) {
                return StringUtils.arrayToString((short[])o, maxArrayElements);
            }
            if (eClass == int[].class) {
                return StringUtils.arrayToString((int[])o, maxArrayElements);
            }
            if (eClass == long[].class) {
                return StringUtils.arrayToString((long[])o, maxArrayElements);
            }
            if (eClass == float[].class) {
                return StringUtils.arrayToString((float[])o, maxArrayElements);
            }
            if (eClass == double[].class) {
                return StringUtils.arrayToString((double[])o, maxArrayElements);
            }
            return StringUtils.arrayToString((Object[])o, maxArrayElements);
        }
        return o.toString();
    }

    public static <T> String arrayToString(T[] array) {
        if (array == null) {
            return "null";
        }
        return Arrays.stream(array).map(String::valueOf).collect(Collectors.joining(", "));
    }

    private static <T> String arrayToString(T[] a, int maxArrayElements) {
        if (maxArrayElements < 0) {
            maxArrayElements = 0;
        }
        if (a == null) {
            return "null";
        }
        String className = a.getClass().getSimpleName();
        int iMax = a.length;
        if (iMax > maxArrayElements) {
            iMax = maxArrayElements;
        }
        Class<?> componentType = a.getClass().getComponentType();
        if (--iMax == -1) {
            return componentType.getSimpleName() + "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append(componentType.getSimpleName());
        b.append('[');
        int i = 0;
        while (true) {
            b.append(String.valueOf(a[i]));
            if (i == iMax) {
                int skipCount = a.length - maxArrayElements;
                if (skipCount > 0) {
                    if (i > 0) {
                        b.append(", ");
                    }
                    b.append("and ");
                    b.append(skipCount);
                    b.append(" more");
                }
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    private static String arrayToString(boolean[] a, int maxArrayElements) {
        if (maxArrayElements < 0) {
            maxArrayElements = 0;
        }
        if (a == null) {
            return "null";
        }
        int iMax = a.length;
        if (iMax > maxArrayElements) {
            iMax = maxArrayElements;
        }
        if (--iMax == -1) {
            return "boolean[]";
        }
        StringBuilder b = new StringBuilder();
        b.append("boolean[");
        int i = 0;
        while (true) {
            b.append(a[i]);
            if (i == iMax) {
                int skipCount = a.length - maxArrayElements;
                if (skipCount > 0) {
                    if (i > 0) {
                        b.append(", ");
                    }
                    b.append("and ");
                    b.append(skipCount);
                    b.append(" more");
                }
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    private static String arrayToString(byte[] a, int maxArrayElements) {
        if (maxArrayElements < 0) {
            maxArrayElements = 0;
        }
        if (a == null) {
            return "null";
        }
        int iMax = a.length;
        if (iMax > maxArrayElements) {
            iMax = maxArrayElements;
        }
        if (--iMax == -1) {
            return "byte[]";
        }
        StringBuilder b = new StringBuilder();
        b.append("byte[");
        int i = 0;
        while (true) {
            b.append(a[i]);
            if (i == iMax) {
                int skipCount = a.length - maxArrayElements;
                if (skipCount > 0) {
                    if (i > 0) {
                        b.append(", ");
                    }
                    b.append("and ");
                    b.append(skipCount);
                    b.append(" more");
                }
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    private static String arrayToString(char[] a, int maxArrayElements) {
        if (maxArrayElements < 0) {
            maxArrayElements = 0;
        }
        if (a == null) {
            return "null";
        }
        int iMax = a.length;
        if (iMax > maxArrayElements) {
            iMax = maxArrayElements;
        }
        if (--iMax == -1) {
            return "char[]";
        }
        StringBuilder b = new StringBuilder();
        b.append("char[");
        int i = 0;
        while (true) {
            b.append(a[i]);
            if (i == iMax) {
                int skipCount = a.length - maxArrayElements;
                if (skipCount > 0) {
                    if (i > 0) {
                        b.append(", ");
                    }
                    b.append("and ");
                    b.append(skipCount);
                    b.append(" more");
                }
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    private static String arrayToString(short[] a, int maxArrayElements) {
        if (maxArrayElements < 0) {
            maxArrayElements = 0;
        }
        if (a == null) {
            return "null";
        }
        int iMax = a.length;
        if (iMax > maxArrayElements) {
            iMax = maxArrayElements;
        }
        if (--iMax == -1) {
            return "short[]";
        }
        StringBuilder b = new StringBuilder();
        b.append("short[");
        int i = 0;
        while (true) {
            b.append(a[i]);
            if (i == iMax) {
                int skipCount = a.length - maxArrayElements;
                if (skipCount > 0) {
                    if (i > 0) {
                        b.append(", ");
                    }
                    b.append("and ");
                    b.append(skipCount);
                    b.append(" more");
                }
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    private static String arrayToString(int[] a, int maxArrayElements) {
        if (maxArrayElements < 0) {
            maxArrayElements = 0;
        }
        if (a == null) {
            return "null";
        }
        int iMax = a.length;
        if (iMax > maxArrayElements) {
            iMax = maxArrayElements;
        }
        if (--iMax == -1) {
            return "int[]";
        }
        StringBuilder b = new StringBuilder();
        b.append("int[");
        int i = 0;
        while (true) {
            b.append(a[i]);
            if (i == iMax) {
                int skipCount = a.length - maxArrayElements;
                if (skipCount > 0) {
                    if (i > 0) {
                        b.append(", ");
                    }
                    b.append("and ");
                    b.append(skipCount);
                    b.append(" more");
                }
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    private static String arrayToString(long[] a, int maxArrayElements) {
        if (maxArrayElements < 0) {
            maxArrayElements = 0;
        }
        if (a == null) {
            return "null";
        }
        int iMax = a.length;
        if (iMax > maxArrayElements) {
            iMax = maxArrayElements;
        }
        if (--iMax == -1) {
            return "long[]";
        }
        StringBuilder b = new StringBuilder();
        b.append("long[");
        int i = 0;
        while (true) {
            b.append(a[i]);
            if (i == iMax) {
                int skipCount = a.length - maxArrayElements;
                if (skipCount > 0) {
                    if (i > 0) {
                        b.append(", ");
                    }
                    b.append("and ");
                    b.append(skipCount);
                    b.append(" more");
                }
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    private static String arrayToString(float[] a, int maxArrayElements) {
        if (maxArrayElements < 0) {
            maxArrayElements = 0;
        }
        if (a == null) {
            return "null";
        }
        int iMax = a.length;
        if (iMax > maxArrayElements) {
            iMax = maxArrayElements;
        }
        if (--iMax == -1) {
            return "float[]";
        }
        StringBuilder b = new StringBuilder();
        b.append("float[");
        int i = 0;
        while (true) {
            b.append(a[i]);
            if (i == iMax) {
                int skipCount = a.length - maxArrayElements;
                if (skipCount > 0) {
                    if (i > 0) {
                        b.append(", ");
                    }
                    b.append("and ");
                    b.append(skipCount);
                    b.append(" more");
                }
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    private static String arrayToString(double[] a, int maxArrayElements) {
        if (maxArrayElements < 0) {
            maxArrayElements = 0;
        }
        if (a == null) {
            return "null";
        }
        int iMax = a.length;
        if (iMax > maxArrayElements) {
            iMax = maxArrayElements;
        }
        if (--iMax == -1) {
            return "double[]";
        }
        StringBuilder b = new StringBuilder();
        b.append("double[");
        int i = 0;
        while (true) {
            b.append(a[i]);
            if (i == iMax) {
                int skipCount = a.length - maxArrayElements;
                if (skipCount > 0) {
                    if (i > 0) {
                        b.append(", ");
                    }
                    b.append("and ");
                    b.append(skipCount);
                    b.append(" more");
                }
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }
}

