/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tx;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.RemoteOperationException;
import org.apache.geode.internal.cache.tx.RemoteOperationMessage;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.logging.log4j.Logger;

public class RemoteSizeMessage
extends RemoteOperationMessage {
    private static final Logger logger = LogService.getLogger();

    public RemoteSizeMessage() {
    }

    private RemoteSizeMessage(DistributedMember recipient, String regionPath, ReplyProcessor21 processor) {
        super((InternalDistributedMember)recipient, regionPath, processor);
    }

    public RemoteSizeMessage(DataInput in) throws IOException, ClassNotFoundException {
        this.fromData(in);
    }

    public static SizeResponse send(DistributedMember distributedMember, InternalRegion r) {
        Assert.assertTrue(distributedMember != null, "RemoteSizeMessage NULL recipients set");
        SizeResponse p = new SizeResponse(r.getSystem(), distributedMember);
        RemoteSizeMessage m = new RemoteSizeMessage(distributedMember, r.getFullPath(), (ReplyProcessor21)p);
        r.getDistributionManager().putOutgoing(m);
        return p;
    }

    @Override
    public boolean canStartRemoteTransaction() {
        return false;
    }

    @Override
    protected boolean operateOnRegion(ClusterDistributionManager dm, LocalRegion r, long startTime) throws RemoteOperationException {
        int size = r.size();
        SizeReplyMessage.send(this.getSender(), this.getProcessorId(), dm, size);
        return false;
    }

    @Override
    protected void appendFields(StringBuffer buff) {
        super.appendFields(buff);
    }

    @Override
    public int getDSFID() {
        return -36;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        DataSerializer.readArrayList(in);
        in.readByte();
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeArrayList(null, out);
        out.writeByte(0);
    }

    public static class SizeResponse
    extends ReplyProcessor21 {
        private int returnValue;

        public SizeResponse(InternalDistributedSystem ds, DistributedMember recipient) {
            super(ds, (InternalDistributedMember)recipient);
        }

        @Override
        protected void processException(ReplyException ex) {
            logger.debug("SizeResponse ignoring exception: {}", (Object)ex.getMessage(), (Object)ex);
        }

        @Override
        public void process(DistributionMessage msg) {
            try {
                if (msg instanceof SizeReplyMessage) {
                    SizeReplyMessage reply = (SizeReplyMessage)msg;
                    this.returnValue = reply.getSize();
                }
            }
            finally {
                super.process(msg);
            }
        }

        public int waitForSize() {
            try {
                this.waitForRepliesUninterruptibly();
            }
            catch (ReplyException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RegionDestroyedException) {
                    RegionDestroyedException rde = (RegionDestroyedException)cause;
                    throw rde;
                }
                throw e;
            }
            return this.returnValue;
        }
    }

    public static class SizeReplyMessage
    extends ReplyMessage {
        private int size;

        public SizeReplyMessage() {
        }

        private SizeReplyMessage(int processorId, int size) {
            this.processorId = processorId;
            this.size = size;
        }

        public SizeReplyMessage(DataInput in) throws IOException, ClassNotFoundException {
            this.fromData(in);
        }

        public static void send(InternalDistributedMember recipient, int processorId, DistributionManager dm, int size) {
            Assert.assertTrue(recipient != null, "SizeReplyMessage NULL reply message");
            SizeReplyMessage m = new SizeReplyMessage(processorId, size);
            m.setRecipient(recipient);
            dm.putOutgoing(m);
        }

        @Override
        public void process(DistributionManager dm, ReplyProcessor21 processor) {
            long startTime = this.getTimestamp();
            if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                logger.trace(LogMarker.DM_VERBOSE, "{}: process invoking reply processor with processorId: {}", (Object)this.processorId);
            }
            if (processor == null) {
                if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                    logger.trace(LogMarker.DM_VERBOSE, "{} processor not found", (Object)this.getClass().getName());
                }
                return;
            }
            processor.process(this);
            if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                logger.trace(LogMarker.DM_VERBOSE, "{} processed {}", (Object)this.getClass().getName(), (Object)this);
            }
            dm.getStats().incReplyMessageTime(DistributionStats.getStatTime() - startTime);
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            out.writeInt(this.size);
        }

        @Override
        public int getDSFID() {
            return -35;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.size = in.readInt();
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getClass().getName()).append(" processorid=").append(this.processorId).append(" reply to sender ").append(this.getSender()).append(" returning size=").append(this.getSize());
            return sb.toString();
        }

        public int getSize() {
            return this.size;
        }
    }
}

