/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tx;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.geode.CancelException;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.TransactionException;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.HeapDataOutputStream;
import org.apache.geode.internal.cache.InitialImageOperation;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.RemoteOperationException;
import org.apache.geode.internal.cache.tx.RemoteOperationMessage;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.util.ObjectIntProcedure;
import org.apache.logging.log4j.Logger;

public class RemoteFetchKeysMessage
extends RemoteOperationMessage {
    private static final Logger logger = LogService.getLogger();

    public RemoteFetchKeysMessage() {
    }

    private RemoteFetchKeysMessage(InternalDistributedMember recipient, String regionPath, ReplyProcessor21 processor) {
        super(recipient, regionPath, processor);
    }

    @Override
    protected boolean operateOnRegion(ClusterDistributionManager dm, LocalRegion r, long startTime) throws RemoteOperationException {
        block3: {
            if (!(r instanceof PartitionedRegion)) {
                r.waitOnInitialization();
            }
            Set keys = r.keySet();
            try {
                RemoteFetchKeysReplyMessage.send(this.getSender(), this.processorId, dm, keys);
            }
            catch (IOException io) {
                if (!logger.isDebugEnabled()) break block3;
                logger.debug("Caught exception while sending keys: {}", (Object)io.getMessage(), (Object)io);
                throw new RemoteOperationException(LocalizedStrings.FetchKeysMessage_UNABLE_TO_SEND_RESPONSE_TO_FETCH_KEYS_REQUEST.toLocalizedString(), io);
            }
        }
        return false;
    }

    @Override
    public int getDSFID() {
        return -37;
    }

    public static FetchKeysResponse send(LocalRegion currRegion, DistributedMember target) {
        FetchKeysResponse response = new FetchKeysResponse(currRegion.getSystem(), (InternalDistributedMember)target);
        RemoteFetchKeysMessage msg = new RemoteFetchKeysMessage((InternalDistributedMember)target, currRegion.getFullPath(), response);
        currRegion.getSystem().getDistributionManager().putOutgoing(msg);
        return response;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
    }

    public static class FetchKeysResponse
    extends ReplyProcessor21 {
        private final Set<Object> returnValue;
        private final Object endLock = new Object();
        private volatile int chunksProcessed;
        private volatile int chunksExpected;
        private volatile boolean lastChunkReceived;

        public FetchKeysResponse(InternalDistributedSystem system, InternalDistributedMember member) {
            super(system, member);
            this.returnValue = new HashSet<Object>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void process(DistributionMessage msg) {
            boolean doneProcessing = false;
            try {
                RemoteFetchKeysReplyMessage fkrm;
                doneProcessing = msg instanceof RemoteFetchKeysReplyMessage ? ((fkrm = (RemoteFetchKeysReplyMessage)msg).getException() != null ? true : this.processChunk((RemoteFetchKeysReplyMessage)msg)) : true;
            }
            finally {
                if (doneProcessing) {
                    super.process(msg);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean processChunk(RemoteFetchKeysReplyMessage msg) {
            boolean doneProcessing = false;
            try {
                ByteArrayInputStream byteStream = new ByteArrayInputStream(msg.chunk);
                DataInputStream in = new DataInputStream(byteStream);
                while (in.available() > 0) {
                    Object key = DataSerializer.readObject(in);
                    if (key != null) {
                        Set<Object> set = this.returnValue;
                        synchronized (set) {
                            this.returnValue.add(key);
                            continue;
                        }
                    }
                    Assert.assertTrue(in.available() == 0);
                }
                Object object = this.endLock;
                synchronized (object) {
                    ++this.chunksProcessed;
                    if (msg.seriesNum + 1 == msg.numSeries && msg.lastInSeries) {
                        this.lastChunkReceived = true;
                        this.chunksExpected = msg.msgNum + 1;
                    }
                    if (this.lastChunkReceived && this.chunksExpected == this.chunksProcessed) {
                        doneProcessing = true;
                    }
                    if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                        logger.trace(LogMarker.DM_VERBOSE, "{} chunksProcessed={},lastChunkReceived={},chunksExpected={},done={}", (Object)this, (Object)this.chunksProcessed, (Object)this.lastChunkReceived, (Object)this.chunksExpected, (Object)doneProcessing);
                    }
                }
            }
            catch (Exception e) {
                this.processException(new ReplyException(LocalizedStrings.FetchKeysMessage_ERROR_DESERIALIZING_KEYS.toLocalizedString(), e));
            }
            return doneProcessing;
        }

        public Set waitForKeys() {
            block2: {
                try {
                    this.waitForRepliesUninterruptibly();
                }
                catch (ReplyException e) {
                    e.handleCause();
                    if (this.lastChunkReceived) break block2;
                    throw new TransactionException(e);
                }
            }
            return Collections.unmodifiableSet(this.returnValue);
        }
    }

    public static class RemoteFetchKeysReplyMessage
    extends ReplyMessage {
        int seriesNum;
        int msgNum;
        int numSeries;
        boolean lastInSeries;
        transient HeapDataOutputStream chunkStream;
        transient byte[] chunk;

        public RemoteFetchKeysReplyMessage() {
        }

        private RemoteFetchKeysReplyMessage(InternalDistributedMember recipient, int processorId, HeapDataOutputStream chunk, int seriesNum, int msgNum, int numSeries, boolean lastInSeries) {
            this.setRecipient(recipient);
            this.setProcessorId(processorId);
            this.seriesNum = seriesNum;
            this.msgNum = msgNum;
            this.numSeries = numSeries;
            this.lastInSeries = lastInSeries;
            this.chunkStream = chunk;
        }

        public static void send(final InternalDistributedMember recipient, final int processorId, final DistributionManager dm, Set<?> keys) throws IOException {
            Assert.assertTrue(recipient != null, "FetchKeysReplyMessage NULL reply message");
            boolean numSeries = true;
            boolean seriesNum = false;
            if (logger.isDebugEnabled()) {
                logger.debug("Starting region keys chunking for {} keys to member {}", (Object)keys.size(), (Object)recipient);
            }
            boolean finished = RemoteFetchKeysReplyMessage.chunkSet(recipient, keys, InitialImageOperation.CHUNK_SIZE_IN_BYTES, false, new ObjectIntProcedure(){
                int msgNum = 0;
                boolean last = false;

                @Override
                public boolean executeWith(Object a, int b) {
                    HeapDataOutputStream chunk = (HeapDataOutputStream)a;
                    this.last = b > 0;
                    try {
                        boolean okay = RemoteFetchKeysReplyMessage.sendChunk(recipient, processorId, dm, chunk, 0, this.msgNum++, 1, this.last);
                        return okay;
                    }
                    catch (CancelException e) {
                        return false;
                    }
                }
            });
            if (logger.isDebugEnabled()) {
                logger.debug("{} region keys chunking", (Object)(finished ? "Finished" : "DID NOT complete"));
            }
        }

        static boolean sendChunk(InternalDistributedMember recipient, int processorId, DistributionManager dm, HeapDataOutputStream chunk, int seriesNum, int msgNum, int numSeries, boolean lastInSeries) {
            RemoteFetchKeysReplyMessage reply = new RemoteFetchKeysReplyMessage(recipient, processorId, chunk, seriesNum, msgNum, numSeries, lastInSeries);
            Set failures = dm.putOutgoing(reply);
            return failures == null || failures.size() == 0;
        }

        static boolean chunkSet(InternalDistributedMember recipient, Set<?> set, int CHUNK_SIZE_IN_BYTES, boolean includeValues, ObjectIntProcedure proc) throws IOException {
            Iterator<?> it = set.iterator();
            boolean keepGoing = true;
            boolean sentLastChunk = false;
            HeapDataOutputStream mos = new HeapDataOutputStream(InitialImageOperation.CHUNK_SIZE_IN_BYTES + 2048, recipient.getVersionObject());
            do {
                mos.reset();
                int avgItemSize = 0;
                int itemCount = 0;
                while (mos.size() + avgItemSize < InitialImageOperation.CHUNK_SIZE_IN_BYTES && it.hasNext()) {
                    Object key = it.next();
                    DataSerializer.writeObject(key, mos);
                    avgItemSize = mos.size() / ++itemCount;
                }
                DataSerializer.writeObject(null, mos);
                int lastMsg = it.hasNext() ? 0 : 1;
                keepGoing = proc.executeWith(mos, lastMsg);
                boolean bl = sentLastChunk = lastMsg == 1 && keepGoing;
            } while (keepGoing && it.hasNext());
            return sentLastChunk;
        }

        @Override
        public void process(DistributionManager dm, ReplyProcessor21 p) {
            long startTime = this.getTimestamp();
            FetchKeysResponse processor = (FetchKeysResponse)p;
            if (processor == null) {
                if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                    logger.trace(LogMarker.DM_VERBOSE, "FetchKeysReplyMessage processor not found");
                }
                return;
            }
            processor.process(this);
            if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                logger.trace(LogMarker.DM_VERBOSE, "{} Remote-processed {}", (Object)processor, (Object)this);
            }
            dm.getStats().incReplyMessageTime(DistributionStats.getStatTime() - startTime);
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            out.writeInt(this.seriesNum);
            out.writeInt(this.msgNum);
            out.writeInt(this.numSeries);
            out.writeBoolean(this.lastInSeries);
            DataSerializer.writeObjectAsByteArray(this.chunkStream, out);
        }

        @Override
        public int getDSFID() {
            return -38;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.seriesNum = in.readInt();
            this.msgNum = in.readInt();
            this.numSeries = in.readInt();
            this.lastInSeries = in.readBoolean();
            this.chunk = DataSerializer.readByteArray(in);
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("RemoteFetchKeysReplyMessage ").append("processorid=").append(this.processorId);
            if (this.getSender() != null) {
                sb.append(",sender=").append(this.getSender());
            }
            sb.append(",seriesNum=").append(this.seriesNum).append(",msgNum=").append(this.msgNum).append(",numSeries=").append(this.numSeries).append(",lastInSeries=").append(this.lastInSeries);
            if (this.chunkStream != null) {
                sb.append(",size=").append(this.chunkStream.size());
            } else if (this.chunk != null) {
                sb.append(",size=").append(this.chunk.length);
            }
            if (this.getException() != null) {
                sb.append(", exception=").append(this.getException());
            }
            return sb.toString();
        }
    }
}

