/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tx;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.CacheException;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.TransactionException;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.NanoTimer;
import org.apache.geode.internal.cache.EntrySnapshot;
import org.apache.geode.internal.cache.KeyInfo;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.NonLocalRegionEntry;
import org.apache.geode.internal.cache.RemoteOperationException;
import org.apache.geode.internal.cache.tx.RemoteOperationMessage;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.logging.log4j.Logger;

public class RemoteFetchEntryMessage
extends RemoteOperationMessage {
    private static final Logger logger = LogService.getLogger();
    private Object key;

    public RemoteFetchEntryMessage() {
    }

    private RemoteFetchEntryMessage(InternalDistributedMember recipient, String regionPath, ReplyProcessor21 processor, Object key) {
        super(recipient, regionPath, processor);
        this.key = key;
    }

    public static FetchEntryResponse send(InternalDistributedMember recipient, LocalRegion r, Object key) throws RemoteOperationException {
        Assert.assertTrue(recipient != null, "RemoteFetchEntryMessage NULL recipient");
        FetchEntryResponse p = new FetchEntryResponse(r.getSystem(), recipient, r, key);
        RemoteFetchEntryMessage m = new RemoteFetchEntryMessage(recipient, r.getFullPath(), p, key);
        Set failures = r.getDistributionManager().putOutgoing(m);
        if (failures != null && failures.size() > 0) {
            throw new RemoteOperationException(LocalizedStrings.RemoteFetchEntryMessage_FAILED_SENDING_0.toLocalizedString(m));
        }
        return p;
    }

    @Override
    protected boolean operateOnRegion(ClusterDistributionManager dm, LocalRegion r, long startTime) throws RemoteOperationException {
        r.waitOnInitialization();
        try {
            KeyInfo keyInfo = r.getKeyInfo(this.key);
            Region.Entry re = r.getDataView().getEntry(keyInfo, r, true);
            if (re == null) {
                r.checkEntryNotFound(this.key);
            }
            NonLocalRegionEntry nlre = new NonLocalRegionEntry(re, r);
            LocalRegion dataReg = r.getDataRegionForRead(keyInfo);
            EntrySnapshot val = new EntrySnapshot(nlre, dataReg, r, false);
            FetchEntryReplyMessage.send(this.getSender(), this.getProcessorId(), val, dm, null);
        }
        catch (TransactionException tex) {
            FetchEntryReplyMessage.send(this.getSender(), this.getProcessorId(), null, dm, new ReplyException(tex));
        }
        catch (EntryNotFoundException enfe) {
            FetchEntryReplyMessage.send(this.getSender(), this.getProcessorId(), null, dm, new ReplyException(LocalizedStrings.RemoteFetchEntryMessage_ENTRY_NOT_FOUND.toLocalizedString(), enfe));
        }
        return false;
    }

    @Override
    protected void appendFields(StringBuffer buff) {
        super.appendFields(buff);
        buff.append("; key=").append(this.key);
    }

    @Override
    public int getDSFID() {
        return -33;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.key = DataSerializer.readObject(in);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject(this.key, out);
    }

    public void setKey(Object key) {
        this.key = key;
    }

    public static class FetchEntryResponse
    extends RemoteOperationMessage.RemoteOperationResponse {
        private volatile EntrySnapshot returnValue;
        final LocalRegion region;
        final Object key;

        public FetchEntryResponse(InternalDistributedSystem ds, InternalDistributedMember recipient, LocalRegion theRegion, Object key) {
            super(ds, recipient);
            this.region = theRegion;
            this.key = key;
        }

        @Override
        public void process(DistributionMessage msg) {
            try {
                if (msg instanceof FetchEntryReplyMessage) {
                    FetchEntryReplyMessage reply = (FetchEntryReplyMessage)msg;
                    this.returnValue = reply.getValue();
                    if (this.returnValue != null) {
                        this.returnValue.setRegion(this.region);
                    }
                    if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                        logger.trace(LogMarker.DM_VERBOSE, "FetchEntryResponse return value is {}", (Object)this.returnValue);
                    }
                }
            }
            finally {
                super.process(msg);
            }
        }

        public EntrySnapshot waitForResponse() throws EntryNotFoundException, RemoteOperationException {
            try {
                this.waitForRemoteResponse();
            }
            catch (EntryNotFoundException | TransactionException e) {
                throw e;
            }
            catch (CacheException ce) {
                logger.debug("FetchEntryResponse failed with remote CacheException", (Throwable)ce);
                throw new RemoteOperationException("FetchEntryResponse failed with remote CacheException", ce);
            }
            return this.returnValue;
        }
    }

    public static class FetchEntryReplyMessage
    extends ReplyMessage {
        private EntrySnapshot value;

        public FetchEntryReplyMessage() {
        }

        private FetchEntryReplyMessage(int processorId, EntrySnapshot value, ReplyException re) {
            this.processorId = processorId;
            this.value = value;
            this.setException(re);
        }

        public static void send(InternalDistributedMember recipient, int processorId, EntrySnapshot value, DistributionManager dm, ReplyException re) {
            Assert.assertTrue(recipient != null, "FetchEntryReplyMessage NULL recipient");
            FetchEntryReplyMessage m = new FetchEntryReplyMessage(processorId, value, re);
            m.setRecipient(recipient);
            dm.putOutgoing(m);
        }

        @Override
        public void process(DistributionManager dm, ReplyProcessor21 processor) {
            boolean isDebugEnabled = logger.isTraceEnabled(LogMarker.DM_VERBOSE);
            long startTime = this.getTimestamp();
            if (isDebugEnabled) {
                logger.trace(LogMarker.DM_VERBOSE, "FetchEntryReplyMessage process invoking reply processor with processorId:{}", (Object)this.processorId);
            }
            if (processor == null) {
                if (isDebugEnabled) {
                    logger.trace(LogMarker.DM_VERBOSE, "FetchEntryReplyMessage processor not found");
                }
                return;
            }
            processor.process(this);
            if (isDebugEnabled) {
                logger.trace(LogMarker.DM_VERBOSE, "{}  processed  {}", (Object)processor, (Object)this);
            }
            dm.getStats().incReplyMessageTime(NanoTimer.getTime() - startTime);
        }

        public EntrySnapshot getValue() {
            return this.value;
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            if (this.value == null) {
                out.writeBoolean(true);
            } else {
                out.writeBoolean(false);
                InternalDataSerializer.invokeToData(this.value, out);
            }
        }

        @Override
        public int getDSFID() {
            return -34;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            boolean nullEntry = in.readBoolean();
            if (!nullEntry) {
                this.value = new EntrySnapshot(in, null);
            }
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("FetchEntryReplyMessage ").append("processorid=").append(this.processorId).append(" reply to sender ").append(this.getSender()).append(" returning value=").append(this.value);
            return sb.toString();
        }
    }
}

