/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import java.util.List;
import org.apache.geode.cache.DynamicRegionFactory;
import org.apache.geode.cache.InterestResultPolicy;
import org.apache.geode.cache.operations.RegisterInterestOperationContext;
import org.apache.geode.i18n.StringId;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.tier.CachedRegionHelper;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.ChunkedMessage;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.security.AuthorizeRequest;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.security.ResourcePermission;

public class RegisterInterestList66
extends BaseCommand {
    private static final RegisterInterestList66 singleton = new RegisterInterestList66();

    public static Command getCommand() {
        return singleton;
    }

    RegisterInterestList66() {
    }

    @Override
    public void cmdExecute(Message clientMessage, ServerConnection serverConnection, SecurityService securityService, long start) throws IOException, InterruptedException {
        LocalRegion region;
        byte[] regionDataPolicyPartBytes;
        InterestResultPolicy policy;
        Part regionNamePart = null;
        Object keyPart = null;
        String regionName = null;
        Object key = null;
        List keys = null;
        CachedRegionHelper crHelper = serverConnection.getCachedRegionHelper();
        int numberOfKeys = 0;
        int partNumber = 0;
        serverConnection.setAsTrue(2);
        serverConnection.setAsTrue(3);
        ChunkedMessage chunkedResponseMsg = serverConnection.getRegisterInterestResponseMessage();
        regionNamePart = clientMessage.getPart(0);
        regionName = regionNamePart.getString();
        try {
            policy = (InterestResultPolicy)clientMessage.getPart(1).getObject();
        }
        catch (Exception e) {
            RegisterInterestList66.writeChunkedException(clientMessage, e, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        boolean isDurable = false;
        try {
            Part durablePart = clientMessage.getPart(2);
            byte[] durablePartBytes = (byte[])durablePart.getObject();
            isDurable = durablePartBytes[0] == 1;
        }
        catch (Exception e) {
            RegisterInterestList66.writeChunkedException(clientMessage, e, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        boolean serializeValues = false;
        try {
            Part regionDataPolicyPart = clientMessage.getPart(clientMessage.getNumberOfParts() - 1);
            regionDataPolicyPartBytes = (byte[])regionDataPolicyPart.getObject();
            if (serverConnection.getClientVersion().compareTo(Version.GFE_80) >= 0) {
                serializeValues = regionDataPolicyPartBytes[1] == 1;
            }
        }
        catch (Exception e) {
            RegisterInterestList66.writeChunkedException(clientMessage, e, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        partNumber = 3;
        Part list = clientMessage.getPart(partNumber);
        try {
            keys = (List)list.getObject();
            numberOfKeys = keys.size();
        }
        catch (Exception e) {
            RegisterInterestList66.writeChunkedException(clientMessage, e, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        boolean sendUpdatesAsInvalidates = false;
        try {
            Part notifyPart = clientMessage.getPart(partNumber + 1);
            byte[] notifyPartBytes = (byte[])notifyPart.getObject();
            sendUpdatesAsInvalidates = notifyPartBytes[0] == 1;
        }
        catch (Exception e) {
            RegisterInterestList66.writeChunkedException(clientMessage, e, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received register interest 66 request ({} bytes) from {} for the following {} keys in region {}: {}", (Object)serverConnection.getName(), (Object)clientMessage.getPayloadLength(), (Object)serverConnection.getSocketString(), (Object)numberOfKeys, (Object)regionName, (Object)keys);
        }
        if (keys.isEmpty() || regionName == null) {
            StringId errMessage = null;
            if (keys.isEmpty() && regionName == null) {
                errMessage = LocalizedStrings.RegisterInterestList_THE_INPUT_LIST_OF_KEYS_IS_EMPTY_AND_THE_INPUT_REGION_NAME_IS_NULL_FOR_THE_REGISTER_INTEREST_REQUEST;
            } else if (keys.isEmpty()) {
                errMessage = LocalizedStrings.RegisterInterestList_THE_INPUT_LIST_OF_KEYS_FOR_THE_REGISTER_INTEREST_REQUEST_IS_EMPTY;
            } else if (regionName == null) {
                errMessage = LocalizedStrings.RegisterInterest_THE_INPUT_REGION_NAME_FOR_THE_REGISTER_INTEREST_REQUEST_IS_NULL;
            }
            String s = errMessage.toLocalizedString();
            logger.warn("{}: {}", (Object)serverConnection.getName(), (Object)s);
            RegisterInterestList66.writeChunkedErrorResponse(clientMessage, 21, s, serverConnection);
            serverConnection.setAsTrue(1);
        }
        if ((region = (LocalRegion)serverConnection.getCache().getRegion(regionName)) == null) {
            logger.info((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.RegisterInterestList_0_REGION_NAMED_1_WAS_NOT_FOUND_DURING_REGISTER_INTEREST_LIST_REQUEST, new Object[]{serverConnection.getName(), regionName}));
        }
        try {
            securityService.authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.READ, regionName);
            AuthorizeRequest authzRequest = serverConnection.getAuthzRequest();
            if (authzRequest != null && !DynamicRegionFactory.regionIsDynamicRegionList(regionName)) {
                RegisterInterestOperationContext registerContext = authzRequest.registerInterestListAuthorize(regionName, keys, policy);
                keys = (List)registerContext.getKey();
            }
            serverConnection.getAcceptor().getCacheClientNotifier().registerClientInterest(regionName, keys, serverConnection.getProxyID(), isDurable, sendUpdatesAsInvalidates, true, regionDataPolicyPartBytes[0], true);
        }
        catch (Exception ex) {
            RegisterInterestList66.checkForInterrupt(serverConnection, ex);
            RegisterInterestList66.writeChunkedException(clientMessage, ex, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        boolean isPrimary = serverConnection.getAcceptor().getCacheClientNotifier().getClientProxy(serverConnection.getProxyID()).isPrimary();
        if (!isPrimary) {
            chunkedResponseMsg.setMessageType(33);
            chunkedResponseMsg.setTransactionId(clientMessage.getTransactionId());
            chunkedResponseMsg.sendHeader();
            chunkedResponseMsg.setLastChunk(true);
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Sending register interest response chunk from secondary for region: {} for key: {} chunk=<{}>", (Object)serverConnection.getName(), (Object)regionName, key, (Object)chunkedResponseMsg);
            }
            chunkedResponseMsg.sendChunk(serverConnection);
        } else {
            chunkedResponseMsg.setMessageType(32);
            chunkedResponseMsg.setTransactionId(clientMessage.getTransactionId());
            chunkedResponseMsg.sendHeader();
            try {
                RegisterInterestList66.fillAndSendRegisterInterestResponseChunks(region, keys, 0, serializeValues, policy, serverConnection);
                serverConnection.setAsTrue(1);
            }
            catch (Exception e) {
                RegisterInterestList66.checkForInterrupt(serverConnection, e);
                RegisterInterestList66.writeChunkedException(clientMessage, e, serverConnection);
                serverConnection.setAsTrue(1);
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Sent register interest response for the following {} keys in region {}: {}", (Object)serverConnection.getName(), (Object)numberOfKeys, (Object)regionName, (Object)keys);
            }
        }
    }
}

