/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.security.GemFireSecurityException;

public class PutUserCredentials
extends BaseCommand {
    private static final PutUserCredentials singleton = new PutUserCredentials();

    public static Command getCommand() {
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cmdExecute(Message clientMessage, ServerConnection serverConnection, SecurityService securityService, long start) throws IOException, ClassNotFoundException, InterruptedException {
        int numberOfParts;
        boolean isSecureMode = clientMessage.isSecureMode();
        if (isSecureMode && (numberOfParts = clientMessage.getNumberOfParts()) == 1) {
            try {
                serverConnection.setAsTrue(2);
                byte[] uniqueId = serverConnection.setCredentials(clientMessage);
                PutUserCredentials.writeResponse(uniqueId, null, clientMessage, false, serverConnection);
            }
            catch (GemFireSecurityException gfse) {
                if (serverConnection.getSecurityLogWriter().warningEnabled()) {
                    serverConnection.getSecurityLogWriter().warning(LocalizedStrings.ONE_ARG, serverConnection.getName() + ": Security exception: " + gfse.toString() + (gfse.getCause() != null ? ", caused by: " + gfse.getCause().toString() : ""));
                }
                PutUserCredentials.writeException(clientMessage, gfse, false, serverConnection);
            }
            catch (Exception ex) {
                if (serverConnection.getLogWriter().warningEnabled()) {
                    serverConnection.getLogWriter().warning(LocalizedStrings.CacheClientNotifier_AN_EXCEPTION_WAS_THROWN_FOR_CLIENT_0_1, new Object[]{serverConnection.getProxyID(), ""}, (Throwable)ex);
                }
                PutUserCredentials.writeException(clientMessage, ex, false, serverConnection);
            }
            finally {
                serverConnection.setAsTrue(1);
            }
        }
    }
}

