/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.snapshot;

import java.io.File;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.snapshot.SnapshotFileMapper;

public class ParallelSnapshotFileMapper
implements SnapshotFileMapper {
    private static final long serialVersionUID = 1L;

    @Override
    public File mapExportPath(DistributedMember member, File snapshot) {
        String baseName = this.getBaseName(snapshot);
        String memberUniqueId = this.createUniqueId((InternalDistributedMember)member);
        String fullName = baseName + "-" + memberUniqueId + ".gfd";
        return new File(snapshot.getParentFile(), fullName);
    }

    @Override
    public File[] mapImportPath(DistributedMember member, File snapshot) {
        return new File[]{snapshot};
    }

    private String getBaseName(File snapshot) {
        String filename = snapshot.getName();
        int suffixLocation = filename.indexOf(".gfd");
        if (suffixLocation < 0) {
            throw new IllegalArgumentException("Snapshot file '" + filename + "' missing backup file extension (.gfd)");
        }
        return filename.substring(0, suffixLocation);
    }

    private String createUniqueId(InternalDistributedMember member) {
        String address = member.getInetAddress().getHostAddress();
        String alphanumericAddress = address.replaceAll("\\.|:", "");
        int port = member.getPort();
        return alphanumericAddress + port;
    }
}

