/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.partitioned.rebalance.model;

import org.apache.geode.internal.cache.partitioned.rebalance.model.Bucket;
import org.apache.geode.internal.cache.partitioned.rebalance.model.Member;

public enum RefusalReason {
    NONE,
    ALREADY_HOSTING,
    UNITIALIZED_MEMBER,
    SAME_ZONE,
    LOCAL_MAX_MEMORY_FULL,
    CRITICAL_HEAP;


    public boolean willAccept() {
        return this == NONE;
    }

    public String formatMessage(Member target, Bucket bucket) {
        switch (this) {
            case NONE: {
                return "No reason, the move should be allowed.";
            }
            case ALREADY_HOSTING: {
                return "Target member " + target.getMemberId() + " is already hosting bucket " + bucket.getId();
            }
            case UNITIALIZED_MEMBER: {
                return "Target member " + target.getMemberId() + " is not fully initialized";
            }
            case SAME_ZONE: {
                return "Target member " + target.getMemberId() + " is in the same redundancy zone as other members hosting bucket " + bucket.getId() + ": " + bucket.getMembersHosting();
            }
            case LOCAL_MAX_MEMORY_FULL: {
                return "Target member " + target.getMemberId() + " does not have space within it's local max memory for bucket " + bucket.getId() + ". Bucket Size " + bucket.getBytes() + " local max memory: " + target.getConfiguredMaxMemory() + " remaining: " + target.getSize();
            }
            case CRITICAL_HEAP: {
                return "Target member " + target.getMemberId() + " has reached its critical heap percentage, and cannot accept more data";
            }
        }
        return this.toString();
    }
}

