/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.eviction;

import org.apache.geode.StatisticDescriptor;
import org.apache.geode.Statistics;
import org.apache.geode.StatisticsFactory;
import org.apache.geode.StatisticsType;
import org.apache.geode.StatisticsTypeFactory;
import org.apache.geode.internal.cache.eviction.EvictionStats;
import org.apache.geode.internal.statistics.StatisticsTypeFactoryImpl;

public class HeapLRUStatistics
implements EvictionStats {
    private static final StatisticsType statType;
    private static final int counterId;
    private static final int evictionsId;
    private static final int destroysId;
    private static final int evaluationsId;
    private static final int greedyReturnsId;
    private final Statistics stats;

    public HeapLRUStatistics(StatisticsFactory factory, String name) {
        this.stats = factory.createAtomicStatistics(statType, "HeapLRUStatistics-" + name);
    }

    @Override
    public Statistics getStatistics() {
        return this.stats;
    }

    @Override
    public void close() {
        this.stats.close();
    }

    @Override
    public void incEvictions() {
        this.stats.incLong(evictionsId, 1L);
    }

    @Override
    public void updateCounter(long delta) {
        this.stats.incLong(counterId, delta);
    }

    @Override
    public void incDestroys() {
        this.stats.incLong(destroysId, 1L);
    }

    @Override
    public void setLimit(long newValue) {
    }

    @Override
    public void setCounter(long newValue) {
        this.stats.setLong(counterId, newValue);
    }

    @Override
    public void incEvaluations(long delta) {
        this.stats.incLong(evaluationsId, delta);
    }

    @Override
    public void incGreedyReturns(long delta) {
        this.stats.incLong(greedyReturnsId, delta);
    }

    static {
        StatisticsTypeFactory f = StatisticsTypeFactoryImpl.singleton();
        String entryBytesDesc = "The amount of memory currently used by regions configured for eviction.";
        String lruEvictionsDesc = "Number of total entry evictions triggered by LRU.";
        String lruDestroysDesc = "Number of entries destroyed in the region through both destroy cache operations and eviction.";
        String lruEvaluationsDesc = "Number of entries evaluated during LRU operations.";
        String lruGreedyReturnsDesc = "Number of non-LRU entries evicted during LRU operations";
        statType = f.createType("HeapLRUStatistics", "Statistics related to heap based eviction", new StatisticDescriptor[]{f.createLongGauge("entryBytes", "The amount of memory currently used by regions configured for eviction.", "bytes"), f.createLongCounter("lruEvictions", "Number of total entry evictions triggered by LRU.", "entries"), f.createLongCounter("lruDestroys", "Number of entries destroyed in the region through both destroy cache operations and eviction.", "entries"), f.createLongCounter("lruEvaluations", "Number of entries evaluated during LRU operations.", "entries"), f.createLongCounter("lruGreedyReturns", "Number of non-LRU entries evicted during LRU operations", "entries")});
        counterId = statType.nameToId("entryBytes");
        evictionsId = statType.nameToId("lruEvictions");
        destroysId = statType.nameToId("lruDestroys");
        evaluationsId = statType.nameToId("lruEvaluations");
        greedyReturnsId = statType.nameToId("lruGreedyReturns");
    }
}

