/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.entries;

import java.util.UUID;
import org.apache.geode.internal.cache.InlineKeyHelper;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.RegionEntryFactory;
import org.apache.geode.internal.cache.entries.VMThinDiskRegionEntry;
import org.apache.geode.internal.cache.entries.VMThinDiskRegionEntryHeapIntKey;
import org.apache.geode.internal.cache.entries.VMThinDiskRegionEntryHeapLongKey;
import org.apache.geode.internal.cache.entries.VMThinDiskRegionEntryHeapObjectKey;
import org.apache.geode.internal.cache.entries.VMThinDiskRegionEntryHeapStringKey1;
import org.apache.geode.internal.cache.entries.VMThinDiskRegionEntryHeapStringKey2;
import org.apache.geode.internal.cache.entries.VMThinDiskRegionEntryHeapUUIDKey;
import org.apache.geode.internal.cache.entries.VersionedThinDiskRegionEntryHeap;

public abstract class VMThinDiskRegionEntryHeap
extends VMThinDiskRegionEntry {
    private static final VMThinDiskRegionEntryHeapFactory factory = new VMThinDiskRegionEntryHeapFactory();

    public VMThinDiskRegionEntryHeap(RegionEntryContext context, Object value) {
        super(context, value);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VMThinDiskRegionEntryHeapFactory
    implements RegionEntryFactory {
        private VMThinDiskRegionEntryHeapFactory() {
        }

        @Override
        public RegionEntry createEntry(RegionEntryContext context, Object key, Object value) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key.getClass();
                if (keyClass == Integer.class) {
                    return new VMThinDiskRegionEntryHeapIntKey(context, (Integer)key, value);
                }
                if (keyClass == Long.class) {
                    return new VMThinDiskRegionEntryHeapLongKey(context, (Long)key, value);
                }
                if (keyClass == String.class) {
                    String skey = (String)key;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VMThinDiskRegionEntryHeapStringKey1(context, skey, value, byteEncoded);
                        }
                        return new VMThinDiskRegionEntryHeapStringKey2(context, skey, value, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VMThinDiskRegionEntryHeapUUIDKey(context, (UUID)key, value);
                }
            }
            return new VMThinDiskRegionEntryHeapObjectKey(context, key, value);
        }

        @Override
        public Class getEntryClass() {
            return VMThinDiskRegionEntryHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return VersionedThinDiskRegionEntryHeap.getEntryFactory();
        }

        @Override
        public RegionEntryFactory makeOnHeap() {
            return this;
        }
    }
}

