/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.backup;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.geode.internal.cache.backup.ScriptGenerator;
import org.apache.geode.internal.cache.backup.UnixScriptGenerator;
import org.apache.geode.internal.cache.backup.WindowsScriptGenerator;
import org.apache.geode.internal.lang.SystemUtils;

public class RestoreScript {
    static final String INCREMENTAL_MARKER_COMMENT = "Incremental backup.  Restore baseline originals from previous backups.";
    static final String REFUSE_TO_OVERWRITE_MESSAGE = "Backup not restored. Refusing to overwrite ";
    private static final String[] ABOUT_SCRIPT_COMMENT = new String[]{"Restore a backup of gemfire persistent data to the location it was backed up", "from. This script will refuse to restore if the original data still exists.", "This script was automatically generated by the gemfire backup utility."};
    private static final String EXISTENCE_CHECK_COMMENT = "Test for existing originals.  If they exist, do not restore the backup.";
    private static final String RESTORE_DATA_COMMENT = "Restore data";
    private final ScriptGenerator generator;
    private final Map<File, File> baselineFiles = new HashMap<File, File>();
    private final Map<File, File> backedUpFiles = new LinkedHashMap<File, File>();
    private final List<File> existenceTests = new ArrayList<File>();

    public RestoreScript() {
        this(SystemUtils.isWindows() ? new WindowsScriptGenerator() : new UnixScriptGenerator());
    }

    private RestoreScript(ScriptGenerator generator) {
        this.generator = generator;
    }

    public void addBaselineFiles(Map<File, File> baselineFiles) {
        this.baselineFiles.putAll(baselineFiles);
    }

    public void addBaselineFile(File baseline, File absoluteFile) {
        this.baselineFiles.put(baseline, absoluteFile);
    }

    public void addFile(File originalFile, File backupFile) {
        this.backedUpFiles.put(backupFile, originalFile.getAbsoluteFile());
    }

    public void addExistenceTest(File originalFile) {
        this.existenceTests.add(originalFile.getAbsoluteFile());
    }

    public File generate(File outputDir) throws IOException {
        File outputFile = new File(outputDir, this.generator.getScriptName());
        try (BufferedWriter writer = Files.newBufferedWriter(outputFile.toPath(), new OpenOption[0]);){
            this.writePreamble(writer);
            this.writeAbout(writer);
            this.writeExistenceTest(writer);
            this.writeRestoreData(writer, outputDir.toPath());
            this.writeIncrementalData(writer);
            this.generator.writeExit(writer);
        }
        outputFile.setExecutable(true, true);
        return outputFile;
    }

    private void writePreamble(BufferedWriter writer) throws IOException {
        this.generator.writePreamble(writer);
        writer.newLine();
    }

    private void writeAbout(BufferedWriter writer) throws IOException {
        for (String comment : ABOUT_SCRIPT_COMMENT) {
            this.generator.writeComment(writer, comment);
        }
        writer.newLine();
    }

    private void writeExistenceTest(BufferedWriter writer) throws IOException {
        this.generator.writeComment(writer, EXISTENCE_CHECK_COMMENT);
        for (File file : this.existenceTests) {
            this.generator.writeExistenceTest(writer, file);
        }
        writer.newLine();
    }

    private void writeRestoreData(BufferedWriter writer, Path outputDir) throws IOException {
        this.generator.writeComment(writer, RESTORE_DATA_COMMENT);
        for (Map.Entry<File, File> entry : this.backedUpFiles.entrySet()) {
            File backup = entry.getKey();
            String[] backupFiles = backup.list();
            boolean backupHasFiles = backup.isDirectory() && backupFiles != null && backupFiles.length != 0;
            backup = outputDir.relativize(backup.toPath()).toFile();
            File original = entry.getValue();
            if (original.isDirectory()) {
                this.generator.writeCopyDirectoryContents(writer, backup, original, backupHasFiles);
                continue;
            }
            this.generator.writeCopyFile(writer, backup, original);
        }
    }

    private void writeIncrementalData(BufferedWriter writer) throws IOException {
        if (this.baselineFiles.isEmpty()) {
            return;
        }
        writer.newLine();
        this.generator.writeComment(writer, INCREMENTAL_MARKER_COMMENT);
        for (Map.Entry<File, File> entry : this.baselineFiles.entrySet()) {
            this.generator.writeCopyFile(writer, entry.getKey(), entry.getValue());
        }
    }

    public void addUserFile(File original, File dest) {
        this.addExistenceTest(original);
        this.addFile(original, dest);
    }
}

