/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.backup;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.persistence.PersistentID;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.admin.remote.AdminFailureResponse;
import org.apache.geode.internal.admin.remote.AdminResponse;
import org.apache.geode.internal.admin.remote.CliLegacyMessage;
import org.apache.geode.internal.cache.backup.PrepareBackupFactory;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class PrepareBackupRequest
extends CliLegacyMessage {
    private static final Logger logger = LogService.getLogger();
    private final transient PrepareBackupFactory prepareBackupFactory;
    private Properties properties;

    public PrepareBackupRequest() {
        this.prepareBackupFactory = new PrepareBackupFactory();
    }

    PrepareBackupRequest(InternalDistributedMember sender, Set<InternalDistributedMember> recipients, int msgId, PrepareBackupFactory prepareBackupFactory, Properties properties) {
        this.setSender(sender);
        this.setRecipients(recipients);
        this.msgId = msgId;
        this.prepareBackupFactory = prepareBackupFactory;
        this.properties = properties;
    }

    @Override
    protected AdminResponse createResponse(DistributionManager dm) {
        HashSet<PersistentID> persistentIds;
        try {
            persistentIds = this.prepareBackupFactory.createPrepareBackup(dm.getDistributionManagerId(), dm.getCache(), this.properties).run();
        }
        catch (IOException | InterruptedException e) {
            logger.error((Message)LocalizedMessage.create(LocalizedStrings.CliLegacyMessage_ERROR, this.getClass()), (Throwable)e);
            return AdminFailureResponse.create(this.getSender(), e);
        }
        return this.prepareBackupFactory.createBackupResponse(this.getSender(), persistentIds);
    }

    @Override
    public int getDSFID() {
        return 2116;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.properties = DataSerializer.readProperties(in);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeProperties(this.properties, out);
    }
}

