/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.backup;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.Set;
import org.apache.geode.admin.internal.AdminDistributedSystemImpl;
import org.apache.geode.cache.persistence.PersistentID;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.internal.cache.backup.BackupDataStoreHelper;
import org.apache.geode.internal.cache.backup.BackupDataStoreResult;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.management.BackupStatus;
import org.apache.geode.management.ManagementException;
import org.apache.geode.management.internal.BackupStatusImpl;

public class BackupUtil {
    private BackupUtil() {
    }

    public static BackupStatus backupAllMembers(DistributionManager dm, String targetDirPath, String baselineDirPath) {
        Properties properties = BackupUtil.createBackupProperties(targetDirPath, baselineDirPath);
        return BackupUtil.backupAllMembers(dm, properties);
    }

    static Properties createBackupProperties(String targetDirPath, String baselineDirPath) {
        Properties properties = new Properties();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
        properties.setProperty("TIMESTAMP", format.format(new Date()));
        properties.setProperty("TYPE", "FileSystem");
        properties.setProperty("TARGET_DIRECTORY", targetDirPath);
        if (baselineDirPath != null) {
            properties.setProperty("BASELINE_DIRECTORY", baselineDirPath);
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BackupStatus backupAllMembers(DistributionManager dm, Properties properties) throws ManagementException {
        BackupStatusImpl status;
        if (BackupDataStoreHelper.obtainLock(dm)) {
            try {
                Set<PersistentID> missingMembers = AdminDistributedSystemImpl.getMissingPersistentMembers(dm);
                Set recipients = dm.getOtherDistributionManagerIds();
                BackupDataStoreResult result = BackupDataStoreHelper.backupAllMembers(dm, recipients, properties);
                for (Set<PersistentID> onlineMembersIds : result.getSuccessfulMembers().values()) {
                    missingMembers.removeAll(onlineMembersIds);
                }
                result.getExistingDataStores().keySet().removeAll(result.getSuccessfulMembers().keySet());
                for (Set<PersistentID> lostMembersIds : result.getExistingDataStores().values()) {
                    missingMembers.addAll(lostMembersIds);
                }
                status = new BackupStatusImpl(result.getSuccessfulMembers(), missingMembers);
            }
            finally {
                BackupDataStoreHelper.releaseLock(dm);
            }
        } else {
            throw new ManagementException(LocalizedStrings.DistributedSystem_BACKUP_ALREADY_IN_PROGRESS.toLocalizedString());
        }
        return status;
    }
}

