/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.CacheWriterException;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.cache.AbstractUpdateOperation;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.RegionEventImpl;
import org.apache.geode.internal.cache.UpdateOperation;
import org.apache.geode.internal.cache.versions.ConcurrentCacheModificationException;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class QueuedOperation {
    private final Operation op;
    private final Object key;
    private final byte[] value;
    private final Object valueObj;
    private final byte deserializationPolicy;
    private final Object cbArg;

    public QueuedOperation(Operation op, Object key, byte[] value, Object valueObj, byte deserializationPolicy, Object cbArg) {
        this.op = op;
        this.key = key;
        this.value = value;
        this.valueObj = valueObj;
        this.deserializationPolicy = deserializationPolicy;
        this.cbArg = cbArg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void process(LocalRegion lr, DistributedMember src, long lastMod) {
        if (this.op.isRegion()) {
            RegionEventImpl re = new RegionEventImpl(lr, this.op, this.cbArg, true, src);
            if (this.op.isRegionInvalidate()) {
                lr.basicInvalidateRegion(re);
                return;
            } else {
                if (this.op != Operation.REGION_CLEAR) throw new IllegalStateException(LocalizedStrings.QueuedOperation_THE_0_SHOULD_NOT_HAVE_BEEN_QUEUED.toLocalizedString(this.op));
                lr.cmnClearRegion(re, false, false);
            }
            return;
        }
        EntryEventImpl ee = EntryEventImpl.create(lr, this.op, this.key, null, this.cbArg, true, src);
        try {
            if (this.op.isCreate() || this.op.isUpdate()) {
                UpdateOperation.UpdateMessage.setNewValueInEvent(this.value, this.valueObj, ee, this.deserializationPolicy);
                try {
                    long time = lastMod;
                    if (ee.getVersionTag() != null) {
                        time = ee.getVersionTag().getVersionTimeStamp();
                    }
                    if (AbstractUpdateOperation.doPutOrCreate(lr, ee, time)) return;
                    // empty if block
                }
                catch (ConcurrentCacheModificationException time) {}
                return;
            }
            if (this.op.isDestroy()) {
                ee.setOldValueFromRegion();
                try {
                    lr.basicDestroy(ee, false, null);
                    return;
                }
                catch (ConcurrentCacheModificationException time) {
                    return;
                }
                catch (EntryNotFoundException time) {
                    return;
                }
                catch (CacheWriterException e) {
                    throw new Error(LocalizedStrings.QueuedOperation_CACHEWRITER_SHOULD_NOT_BE_CALLED.toLocalizedString(), e);
                }
                catch (TimeoutException e) {
                    throw new Error(LocalizedStrings.QueuedOperation_DISTRIBUTEDLOCK_SHOULD_NOT_BE_ACQUIRED.toLocalizedString(), e);
                }
            }
            if (!this.op.isInvalidate()) throw new IllegalStateException(LocalizedStrings.QueuedOperation_THE_0_SHOULD_NOT_HAVE_BEEN_QUEUED.toLocalizedString(this.op));
            ee.setOldValueFromRegion();
            boolean forceNewEntry = lr.getDataPolicy().withReplication() && !lr.isInitialized();
            boolean invokeCallbacks = lr.isInitialized();
            try {
                lr.basicInvalidate(ee, invokeCallbacks, forceNewEntry);
                return;
            }
            catch (ConcurrentCacheModificationException concurrentCacheModificationException) {
                return;
            }
            catch (EntryNotFoundException entryNotFoundException) {}
            return;
        }
        finally {
            ee.release();
        }
    }

    public static QueuedOperation createFromData(DataInput in) throws IOException, ClassNotFoundException {
        Operation op = Operation.fromOrdinal(in.readByte());
        Object key = null;
        byte[] value = null;
        Object valueObj = null;
        byte deserializationPolicy = 0;
        Object cbArg = DataSerializer.readObject(in);
        if (op.isEntry()) {
            key = DataSerializer.readObject(in);
            if (op.isUpdate() || op.isCreate()) {
                deserializationPolicy = in.readByte();
                value = DataSerializer.readByteArray(in);
            }
        }
        return new QueuedOperation(op, key, value, valueObj, deserializationPolicy, cbArg);
    }

    public void toData(DataOutput out) throws IOException {
        out.writeByte(this.op.ordinal);
        DataSerializer.writeObject(this.cbArg, out);
        if (this.op.isEntry()) {
            DataSerializer.writeObject(this.key, out);
            if (this.op.isUpdate() || this.op.isCreate()) {
                out.writeByte(this.deserializationPolicy);
                DataSerializer.writeByteArray(this.value, out);
            }
        }
    }
}

