/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.geode.cache.DiskAccessException;
import org.apache.geode.internal.cache.CompactableOplog;
import org.apache.geode.internal.cache.DirectoryHolder;
import org.apache.geode.internal.cache.DiskId;
import org.apache.geode.internal.cache.DiskRegion;
import org.apache.geode.internal.cache.DiskStoreImpl;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.OplogSet;
import org.apache.geode.internal.cache.OverflowOplog;
import org.apache.geode.internal.cache.entries.DiskEntry;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class OverflowOplogSet
implements OplogSet {
    private static final Logger logger = LogService.getLogger();
    private final AtomicInteger overflowOplogId = new AtomicInteger(0);
    private OverflowOplog lastOverflowWrite;
    private final ConcurrentMap<Integer, OverflowOplog> overflowMap = new ConcurrentHashMap<Integer, OverflowOplog>();
    private final Map<Integer, OverflowOplog> compactibleOverflowMap = new LinkedHashMap<Integer, OverflowOplog>();
    private int lastOverflowDir = 0;
    private DiskStoreImpl parent;

    public OverflowOplogSet(DiskStoreImpl parent) {
        this.parent = parent;
    }

    OverflowOplog getActiveOverflowOplog() {
        return this.lastOverflowWrite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modify(InternalRegion region, DiskEntry entry, DiskEntry.Helper.ValueWrapper value, boolean async) {
        DiskRegion dr = region.getDiskRegion();
        ConcurrentMap<Integer, OverflowOplog> concurrentMap = this.overflowMap;
        synchronized (concurrentMap) {
            if (this.lastOverflowWrite != null && this.lastOverflowWrite.modify(dr, entry, value, async)) {
                return;
            }
            OverflowOplog oo = this.createOverflowOplog(value.getLength());
            this.addOverflow(oo);
            this.lastOverflowWrite = oo;
            boolean didIt = oo.modify(dr, entry, value, async);
            assert (didIt);
        }
    }

    private long getMaxOplogSizeInBytes() {
        return this.parent.getMaxOplogSizeInBytes();
    }

    private DirectoryHolder[] getDirectories() {
        return this.parent.directories;
    }

    private OverflowOplog createOverflowOplog(long minSize) {
        long availableSpace;
        int i;
        ++this.lastOverflowDir;
        if (this.lastOverflowDir >= this.getDirectories().length) {
            this.lastOverflowDir = 0;
        }
        int idx = -1;
        long maxOplogSizeParam = this.getMaxOplogSizeInBytes();
        if (maxOplogSizeParam < minSize) {
            maxOplogSizeParam = minSize;
        }
        for (i = this.lastOverflowDir; i < this.getDirectories().length; ++i) {
            availableSpace = this.getDirectories()[i].getAvailableSpace();
            if (availableSpace < maxOplogSizeParam) continue;
            idx = i;
            break;
        }
        if (idx == -1 && this.lastOverflowDir != 0) {
            for (i = 0; i < this.lastOverflowDir; ++i) {
                availableSpace = this.getDirectories()[i].getAvailableSpace();
                if (availableSpace < maxOplogSizeParam) continue;
                idx = i;
                break;
            }
        }
        if (idx == -1) {
            for (i = this.lastOverflowDir; i < this.getDirectories().length; ++i) {
                availableSpace = this.getDirectories()[i].getAvailableSpace();
                if (availableSpace < minSize) continue;
                idx = i;
                break;
            }
            if (idx == -1 && this.lastOverflowDir != 0) {
                for (i = 0; i < this.lastOverflowDir; ++i) {
                    availableSpace = this.getDirectories()[i].getAvailableSpace();
                    if (availableSpace < minSize) continue;
                    idx = i;
                    break;
                }
            }
        }
        if (idx == -1) {
            if (this.parent.isCompactionEnabled()) {
                idx = this.lastOverflowDir;
                if (this.getDirectories()[idx].getAvailableSpace() < minSize) {
                    logger.warn((Message)LocalizedMessage.create(LocalizedStrings.DiskRegion_COMPLEXDISKREGIONGETNEXTDIR_MAX_DIRECTORY_SIZE_WILL_GET_VIOLATED__GOING_AHEAD_WITH_THE_SWITCHING_OF_OPLOG_ANY_WAYS_CURRENTLY_AVAILABLE_SPACE_IN_THE_DIRECTORY_IS__0__THE_CAPACITY_OF_DIRECTORY_IS___1, new Object[]{this.getDirectories()[idx].getUsedSpace(), this.getDirectories()[idx].getCapacity()}));
                }
            } else {
                throw new DiskAccessException(LocalizedStrings.Oplog_DIRECTORIES_ARE_FULL_NOT_ABLE_TO_ACCOMODATE_THIS_OPERATIONSWITCHING_PROBLEM_FOR_ENTRY_HAVING_DISKID_0.toLocalizedString("needed " + minSize + " bytes"), this.parent);
            }
        }
        int id = this.overflowOplogId.incrementAndGet();
        this.lastOverflowDir = idx;
        return new OverflowOplog(id, this, this.getDirectories()[idx], minSize);
    }

    void addOverflow(OverflowOplog oo) {
        this.overflowMap.put(oo.getOplogId(), oo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeOverflow(OverflowOplog oo) {
        if (!this.basicRemoveOverflow(oo)) {
            Map<Integer, OverflowOplog> map = this.compactibleOverflowMap;
            synchronized (map) {
                this.compactibleOverflowMap.remove(oo.getOplogId());
            }
        }
    }

    boolean basicRemoveOverflow(OverflowOplog oo) {
        if (this.lastOverflowWrite == oo) {
            this.lastOverflowWrite = null;
        }
        return this.overflowMap.remove(oo.getOplogId(), oo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeOverflow() {
        for (OverflowOplog oo : this.overflowMap.values()) {
            oo.destroy();
        }
        Map<Integer, OverflowOplog> map = this.compactibleOverflowMap;
        synchronized (map) {
            for (OverflowOplog oo : this.compactibleOverflowMap.values()) {
                oo.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeOverflow(DiskRegion dr, DiskEntry entry) {
        DiskId id;
        DiskId diskId = id = entry.getDiskId();
        synchronized (diskId) {
            long oplogId = id.setOplogId(-1L);
            if (oplogId != -1L) {
                ConcurrentMap<Integer, OverflowOplog> concurrentMap = this.overflowMap;
                synchronized (concurrentMap) {
                    OverflowOplog oplog = this.getChild((int)oplogId);
                    if (oplog != null) {
                        oplog.remove(dr, entry);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void copyForwardForOverflowCompact(DiskEntry de, byte[] valueBytes, int length, byte userBits) {
        ConcurrentMap<Integer, OverflowOplog> concurrentMap = this.overflowMap;
        synchronized (concurrentMap) {
            OverflowOplog oo;
            if (this.lastOverflowWrite != null && this.lastOverflowWrite.copyForwardForOverflowCompact(de, valueBytes, length, userBits)) {
                return;
            }
            this.lastOverflowWrite = oo = this.createOverflowOplog(length);
            this.addOverflow(oo);
            boolean didIt = oo.copyForwardForOverflowCompact(de, valueBytes, length, userBits);
            assert (didIt);
        }
    }

    @Override
    public OverflowOplog getChild(long oplogId) {
        return this.getChild((int)oplogId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OverflowOplog getChild(int oplogId) {
        OverflowOplog result = (OverflowOplog)this.overflowMap.get(oplogId);
        if (result == null) {
            Map<Integer, OverflowOplog> map = this.compactibleOverflowMap;
            synchronized (map) {
                result = this.compactibleOverflowMap.get(oplogId);
            }
        }
        return result;
    }

    @Override
    public void create(InternalRegion region, DiskEntry entry, DiskEntry.Helper.ValueWrapper value, boolean async) {
        this.modify(region, entry, value, async);
    }

    @Override
    public void remove(InternalRegion region, DiskEntry entry, boolean async, boolean isClear) {
        this.removeOverflow(region.getDiskRegion(), entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addOverflowToBeCompacted(OverflowOplog oplog) {
        Map<Integer, OverflowOplog> map = this.compactibleOverflowMap;
        synchronized (map) {
            this.compactibleOverflowMap.put(oplog.getOplogId(), oplog);
        }
        this.basicRemoveOverflow(oplog);
        this.parent.scheduleCompaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getCompactableOplogs(List<CompactableOplog> l, int max) {
        Map<Integer, OverflowOplog> map = this.compactibleOverflowMap;
        synchronized (map) {
            Iterator<OverflowOplog> itr = this.compactibleOverflowMap.values().iterator();
            while (itr.hasNext() && l.size() < max) {
                OverflowOplog oplog = itr.next();
                if (!oplog.needsCompaction()) continue;
                l.add(oplog);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void testHookCloseAllOverflowChannels() {
        FileChannel oplogFileChannel;
        Map<Integer, OverflowOplog> map = this.overflowMap;
        synchronized (map) {
            for (OverflowOplog oo : this.overflowMap.values()) {
                oplogFileChannel = oo.getFileChannel();
                try {
                    oplogFileChannel.close();
                }
                catch (IOException iOException) {}
            }
        }
        map = this.compactibleOverflowMap;
        synchronized (map) {
            for (OverflowOplog oo : this.compactibleOverflowMap.values()) {
                oplogFileChannel = oo.getFileChannel();
                try {
                    oplogFileChannel.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArrayList<OverflowOplog> testHookGetAllOverflowOplogs() {
        ArrayList<OverflowOplog> result = new ArrayList<OverflowOplog>();
        Map<Integer, OverflowOplog> map = this.overflowMap;
        synchronized (map) {
            for (OverflowOplog oo : this.overflowMap.values()) {
                result.add(oo);
            }
        }
        map = this.compactibleOverflowMap;
        synchronized (map) {
            for (OverflowOplog oo : this.compactibleOverflowMap.values()) {
                result.add(oo);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void testHookCloseAllOverflowOplogs() {
        Map<Integer, OverflowOplog> map = this.overflowMap;
        synchronized (map) {
            for (OverflowOplog oo : this.overflowMap.values()) {
                oo.close();
            }
        }
        map = this.compactibleOverflowMap;
        synchronized (map) {
            for (OverflowOplog oo : this.compactibleOverflowMap.values()) {
                oo.close();
            }
        }
    }

    public DiskStoreImpl getParent() {
        return this.parent;
    }
}

