/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.internal.admin.remote.AdminRequest;
import org.apache.geode.internal.admin.remote.AdminResponse;
import org.apache.geode.internal.admin.remote.RemoveHealthListenerResponse;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class RemoveHealthListenerRequest
extends AdminRequest {
    private int id;

    public static RemoveHealthListenerRequest create(int id) {
        RemoveHealthListenerRequest m = new RemoveHealthListenerRequest();
        m.id = id;
        return m;
    }

    public RemoveHealthListenerRequest() {
        this.friendlyName = LocalizedStrings.RemoveHealthListenerRequest_REMOVE_HEALTH_LISTENER.toLocalizedString();
    }

    @Override
    protected AdminResponse createResponse(DistributionManager dm) {
        return RemoveHealthListenerResponse.create(dm, this.getSender(), this.id);
    }

    @Override
    public int getDSFID() {
        return 1049;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.id);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.id = in.readInt();
    }

    @Override
    public String toString() {
        return "RemoveHealthListenerRequest from " + this.getRecipient() + " id=" + this.id;
    }
}

