/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.File;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.geode.SystemFailure;
import org.apache.geode.admin.AdminException;
import org.apache.geode.admin.GemFireHealth;
import org.apache.geode.admin.GemFireHealthConfig;
import org.apache.geode.admin.GemFireMemberStatus;
import org.apache.geode.admin.OperationCancelledException;
import org.apache.geode.admin.RegionSubRegionSnapshot;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Config;
import org.apache.geode.internal.admin.AdminBridgeServer;
import org.apache.geode.internal.admin.CacheInfo;
import org.apache.geode.internal.admin.DLockInfo;
import org.apache.geode.internal.admin.GemFireVM;
import org.apache.geode.internal.admin.GfManagerAgent;
import org.apache.geode.internal.admin.HealthListener;
import org.apache.geode.internal.admin.ListenerIdMap;
import org.apache.geode.internal.admin.Stat;
import org.apache.geode.internal.admin.StatAlertDefinition;
import org.apache.geode.internal.admin.StatListener;
import org.apache.geode.internal.admin.StatResource;
import org.apache.geode.internal.admin.remote.AddHealthListenerRequest;
import org.apache.geode.internal.admin.remote.AddHealthListenerResponse;
import org.apache.geode.internal.admin.remote.AddStatListenerRequest;
import org.apache.geode.internal.admin.remote.AddStatListenerResponse;
import org.apache.geode.internal.admin.remote.AdminConsoleDisconnectMessage;
import org.apache.geode.internal.admin.remote.AdminConsoleMessage;
import org.apache.geode.internal.admin.remote.AdminRequest;
import org.apache.geode.internal.admin.remote.AdminResponse;
import org.apache.geode.internal.admin.remote.AppCacheSnapshotMessage;
import org.apache.geode.internal.admin.remote.BridgeServerRequest;
import org.apache.geode.internal.admin.remote.BridgeServerResponse;
import org.apache.geode.internal.admin.remote.CacheConfigRequest;
import org.apache.geode.internal.admin.remote.CacheConfigResponse;
import org.apache.geode.internal.admin.remote.CacheInfoRequest;
import org.apache.geode.internal.admin.remote.CacheInfoResponse;
import org.apache.geode.internal.admin.remote.CancelStatListenerRequest;
import org.apache.geode.internal.admin.remote.ChangeRefreshIntervalMessage;
import org.apache.geode.internal.admin.remote.DurableClientInfoRequest;
import org.apache.geode.internal.admin.remote.DurableClientInfoResponse;
import org.apache.geode.internal.admin.remote.FetchDistLockInfoRequest;
import org.apache.geode.internal.admin.remote.FetchDistLockInfoResponse;
import org.apache.geode.internal.admin.remote.FetchHealthDiagnosisRequest;
import org.apache.geode.internal.admin.remote.FetchHealthDiagnosisResponse;
import org.apache.geode.internal.admin.remote.FetchHostRequest;
import org.apache.geode.internal.admin.remote.FetchHostResponse;
import org.apache.geode.internal.admin.remote.FetchResourceAttributesRequest;
import org.apache.geode.internal.admin.remote.FetchResourceAttributesResponse;
import org.apache.geode.internal.admin.remote.FetchStatsRequest;
import org.apache.geode.internal.admin.remote.FetchStatsResponse;
import org.apache.geode.internal.admin.remote.FetchSysCfgRequest;
import org.apache.geode.internal.admin.remote.FetchSysCfgResponse;
import org.apache.geode.internal.admin.remote.RefreshMemberSnapshotRequest;
import org.apache.geode.internal.admin.remote.RefreshMemberSnapshotResponse;
import org.apache.geode.internal.admin.remote.RegionRequest;
import org.apache.geode.internal.admin.remote.RegionResponse;
import org.apache.geode.internal.admin.remote.RegionSubRegionSizeRequest;
import org.apache.geode.internal.admin.remote.RegionSubRegionsSizeResponse;
import org.apache.geode.internal.admin.remote.RemoteBridgeServer;
import org.apache.geode.internal.admin.remote.RemoteCacheInfo;
import org.apache.geode.internal.admin.remote.RemoteGfManagerAgent;
import org.apache.geode.internal.admin.remote.RemoteStat;
import org.apache.geode.internal.admin.remote.RemoveHealthListenerRequest;
import org.apache.geode.internal.admin.remote.ResetHealthStatusRequest;
import org.apache.geode.internal.admin.remote.RootRegionRequest;
import org.apache.geode.internal.admin.remote.RootRegionResponse;
import org.apache.geode.internal.admin.remote.StatAlertsManagerAssignMessage;
import org.apache.geode.internal.admin.remote.StoreSysCfgRequest;
import org.apache.geode.internal.admin.remote.TailLogRequest;
import org.apache.geode.internal.admin.remote.TailLogResponse;
import org.apache.geode.internal.admin.remote.UpdateAlertDefinitionMessage;
import org.apache.geode.internal.admin.remote.VersionInfoRequest;
import org.apache.geode.internal.admin.remote.VersionInfoResponse;
import org.apache.geode.internal.i18n.LocalizedStrings;

public abstract class RemoteGemFireVM
implements GemFireVM {
    protected final RemoteGfManagerAgent agent;
    protected final InternalDistributedMember id;
    private volatile String name = null;
    private volatile InetAddress host = null;
    private volatile File workingDir = null;
    private volatile Date birthDate = null;
    private volatile File gemfireDir = null;
    private volatile Boolean isDedicatedCacheServer = null;
    protected ListenerIdMap statListeners = new ListenerIdMap();
    private final Object statListenersLock = new Object();
    protected final StatDispatcher dispatcher;
    protected volatile String inspectionClasspath;
    protected volatile boolean unreachable;
    protected volatile int cacheInspectionMode = 100;
    protected final Object healthLock = new Object();
    protected HealthListener healthListener = null;
    protected int healthListenerId = 0;
    static final int LOCK_TIMEOUT_CODE = 1;
    static final int LOCK_LEASE_CODE = 2;
    static final int SEARCH_TIMEOUT_CODE = 3;

    public RemoteGemFireVM(RemoteGfManagerAgent agent, InternalDistributedMember id, int alertLevel) {
        this.agent = agent;
        if (id == null) {
            throw new NullPointerException(LocalizedStrings.RemoteGemFireVM_CANNOT_CREATE_A_REMOTEGEMFIREVM_WITH_A_NULL_ID.toLocalizedString());
        }
        this.id = id;
        this.dispatcher = new StatDispatcher();
        this.sendAsync(AdminConsoleMessage.create(alertLevel));
    }

    public void startStatDispatcher() {
        this.dispatcher.start();
    }

    public String toString() {
        String vmName = null;
        try {
            vmName = this.getName();
        }
        catch (OperationCancelledException operationCancelledException) {
            // empty catch block
        }
        if (vmName == null || vmName.length() == 0) {
            return this.id.toString();
        }
        return vmName;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.initialize();
        }
        return this.name;
    }

    @Override
    public InetAddress getHost() {
        if (this.host == null) {
            this.initialize();
        }
        return this.host;
    }

    @Override
    public File getWorkingDirectory() {
        if (this.workingDir == null) {
            this.initialize();
        }
        return this.workingDir;
    }

    @Override
    public File getGeodeHomeDir() {
        if (this.gemfireDir == null) {
            this.initialize();
        }
        return this.gemfireDir;
    }

    @Override
    public Date getBirthDate() {
        if (this.birthDate == null) {
            this.initialize();
        }
        return this.birthDate;
    }

    public boolean isDedicatedCacheServer() {
        if (this.isDedicatedCacheServer == null) {
            this.initialize();
        }
        return this.isDedicatedCacheServer;
    }

    private void initialize() {
        FetchHostResponse response = (FetchHostResponse)this.sendAndWait(FetchHostRequest.create());
        this.name = response.getName();
        this.host = response.getHost();
        this.workingDir = response.getWorkingDirectory();
        this.gemfireDir = response.getGeodeHomeDir();
        this.birthDate = new Date(response.getBirthDate());
        this.isDedicatedCacheServer = response.isDedicatedCacheServer();
    }

    @Override
    public StatResource[] getAllStats() {
        FetchStatsResponse resp = (FetchStatsResponse)this.sendAndWait(FetchStatsRequest.create(null));
        return resp.getAllStats(this);
    }

    @Override
    public StatResource[] getStats(String statisticsTypeName) {
        FetchStatsResponse resp = (FetchStatsResponse)this.sendAndWait(FetchStatsRequest.create(statisticsTypeName));
        return resp.getAllStats(this);
    }

    @Override
    public DLockInfo[] getDistributedLockInfo() {
        FetchDistLockInfoResponse resp = (FetchDistLockInfoResponse)this.sendAndWait(FetchDistLockInfoRequest.create());
        return resp.getLockInfos();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addStatListener(StatListener observer, StatResource observedResource, Stat observedStat) {
        AddStatListenerResponse resp = (AddStatListenerResponse)this.sendAndWait(AddStatListenerRequest.create(observedResource, observedStat));
        int listenerId = resp.getListenerId();
        Object object = this.statListenersLock;
        synchronized (object) {
            this.statListeners.put(listenerId, observer);
        }
    }

    public void callStatListeners(long timestamp, int[] listenerIds, double[] values) {
        this.dispatcher.put(new DispatchArgs(timestamp, listenerIds, values));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalCallStatListeners(long timestamp, int[] listenerIds, double[] values) {
        ListenerIdMap.Entry[] entries = null;
        ArrayList<Integer> listenersToRemove = new ArrayList<Integer>();
        Object object = this.statListenersLock;
        synchronized (object) {
            entries = this.statListeners.entries();
        }
        for (int j = 0; j < entries.length; ++j) {
            int i;
            int listenerId = entries[j].getKey();
            StatListener sl = (StatListener)entries[j].getValue();
            for (i = 0; i < listenerIds.length && listenerIds[i] != listenerId && listenerIds[i] != -listenerId; ++i) {
            }
            if (i == listenerIds.length) {
                sl.statValueUnchanged(timestamp);
                continue;
            }
            if (listenerIds[i] < 0) {
                listenersToRemove.add(listenerId);
                continue;
            }
            sl.statValueChanged(values[i], timestamp);
        }
        Object object2 = this.statListenersLock;
        synchronized (object2) {
            Iterator iter = listenersToRemove.iterator();
            while (iter.hasNext()) {
                int i = (Integer)iter.next();
                this.statListeners.remove(i);
                this.cancelStatListener(i);
            }
        }
    }

    private void cancelStatListener(int listenerId) {
        this.sendAndWait(CancelStatListenerRequest.create(listenerId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeStatListener(StatListener observer) {
        int listenerId = -1;
        boolean foundIt = false;
        Object object = this.statListenersLock;
        synchronized (object) {
            ListenerIdMap.EntryIterator it = this.statListeners.iterator();
            ListenerIdMap.Entry e = it.next();
            while (e != null) {
                if (e.getValue() == observer) {
                    foundIt = true;
                    listenerId = e.getKey();
                    this.statListeners.remove(listenerId);
                    break;
                }
                e = it.next();
            }
        }
        if (foundIt) {
            this.cancelStatListener(listenerId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addHealthListener(HealthListener observer, GemFireHealthConfig cfg) {
        Object object = this.healthLock;
        synchronized (object) {
            this.healthListener = observer;
            AddHealthListenerResponse response = (AddHealthListenerResponse)this.sendAndWait(AddHealthListenerRequest.create(cfg));
            this.healthListenerId = response.getHealthListenerId();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeHealthListener() {
        Object object = this.healthLock;
        synchronized (object) {
            this.healthListener = null;
            if (this.healthListenerId != 0) {
                this.sendAndWait(RemoveHealthListenerRequest.create(this.healthListenerId));
                this.healthListenerId = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetHealthStatus() {
        Object object = this.healthLock;
        synchronized (object) {
            if (this.healthListenerId != 0) {
                this.sendAndWait(ResetHealthStatusRequest.create(this.healthListenerId));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getHealthDiagnosis(GemFireHealth.Health healthCode) {
        Object object = this.healthLock;
        synchronized (object) {
            if (this.healthListenerId != 0) {
                FetchHealthDiagnosisResponse response = (FetchHealthDiagnosisResponse)this.sendAndWait(FetchHealthDiagnosisRequest.create(this.healthListenerId, healthCode));
                return response.getDiagnosis();
            }
            return new String[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callHealthListeners(int listenerId, GemFireHealth.Health newStatus) {
        HealthListener hl = null;
        Object object = this.healthLock;
        synchronized (object) {
            if (this.healthListenerId == listenerId) {
                hl = this.healthListener;
            }
        }
        if (hl != null) {
            try {
                hl.healthChanged(this, newStatus);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    @Override
    public Config getConfig() {
        FetchSysCfgResponse response = (FetchSysCfgResponse)this.sendAndWait(FetchSysCfgRequest.create());
        return response.getConfig();
    }

    @Override
    public GemFireMemberStatus getSnapshot() {
        RefreshMemberSnapshotResponse response = (RefreshMemberSnapshotResponse)this.sendAndWait(RefreshMemberSnapshotRequest.create());
        return response.getSnapshot();
    }

    @Override
    public RegionSubRegionSnapshot getRegionSnapshot() {
        RegionSubRegionsSizeResponse response = (RegionSubRegionsSizeResponse)this.sendAndWait(RegionSubRegionSizeRequest.create());
        return response.getSnapshot();
    }

    @Override
    public void setConfig(Config cfg) {
        this.sendAndWait(StoreSysCfgRequest.create(cfg));
    }

    @Override
    public GfManagerAgent getManagerAgent() {
        return this.agent;
    }

    @Override
    public String[] getSystemLogs() {
        TailLogResponse resp = (TailLogResponse)this.sendAndWait(TailLogRequest.create());
        String main = resp.getTail();
        String child = resp.getChildTail();
        String[] retVal = null;
        retVal = main != null ? (child != null ? new String[]{main, child} : new String[]{main}) : new String[]{};
        return retVal;
    }

    @Override
    public String getVersionInfo() {
        VersionInfoResponse resp = (VersionInfoResponse)this.sendAndWait(VersionInfoRequest.create());
        return resp.getVersionInfo();
    }

    @Override
    public Region[] getRootRegions() {
        RootRegionResponse resp = (RootRegionResponse)this.sendAndWait(RootRegionRequest.create());
        return resp.getRegions(this);
    }

    @Override
    public Region getRegion(CacheInfo c, String path) {
        RegionResponse resp = (RegionResponse)this.sendAndWait(RegionRequest.createForGet(c, path));
        return resp.getRegion(this);
    }

    @Override
    public Region createVMRootRegion(CacheInfo c, String regionPath, RegionAttributes attrs) throws AdminException {
        RegionResponse resp = (RegionResponse)this.sendAndWait(RegionRequest.createForCreateRoot(c, regionPath, attrs));
        Exception ex = resp.getException();
        if (ex != null) {
            throw new AdminException(LocalizedStrings.RemoteGemFireVM_AN_EXCEPTION_WAS_THROWN_WHILE_CREATING_VM_ROOT_REGION_0.toLocalizedString(regionPath), ex);
        }
        return resp.getRegion(this);
    }

    @Override
    public Region createSubregion(CacheInfo c, String parentPath, String regionPath, RegionAttributes attrs) throws AdminException {
        RegionResponse resp = (RegionResponse)this.sendAndWait(RegionRequest.createForCreateSubregion(c, parentPath, regionPath, attrs));
        Exception ex = resp.getException();
        if (ex != null) {
            throw new AdminException(LocalizedStrings.RemoteGemFireVM_WHILE_CREATING_SUBREGION_0_OF_1.toLocalizedString(regionPath, parentPath), ex);
        }
        return resp.getRegion(this);
    }

    @Override
    public void setCacheInspectionMode(int mode) {
        this.cacheInspectionMode = mode;
    }

    @Override
    public int getCacheInspectionMode() {
        return this.cacheInspectionMode;
    }

    @Override
    public void takeRegionSnapshot(String regionName, int snapshotId) {
        this.sendAsync(AppCacheSnapshotMessage.create(regionName, snapshotId));
    }

    RemoteStat[] getResourceStatsByID(long rsrcId) {
        FetchResourceAttributesResponse response = (FetchResourceAttributesResponse)this.sendAndWait(FetchResourceAttributesRequest.create(rsrcId));
        return response.getStats();
    }

    @Override
    public InternalDistributedMember getId() {
        return this.id;
    }

    @Override
    public CacheInfo getCacheInfo() {
        CacheInfoResponse resp = (CacheInfoResponse)this.sendAndWait(CacheInfoRequest.create());
        RemoteCacheInfo result = resp.getCacheInfo();
        if (result != null) {
            result.setGemFireVM(this);
        }
        return result;
    }

    public boolean hasDurableClient(String durableClientId) {
        DurableClientInfoResponse resp = (DurableClientInfoResponse)this.sendAndWait(DurableClientInfoRequest.create(durableClientId, 10));
        boolean result = resp.getResultBoolean();
        return result;
    }

    public boolean isPrimaryForDurableClient(String durableClientId) {
        DurableClientInfoResponse resp = (DurableClientInfoResponse)this.sendAndWait(DurableClientInfoRequest.create(durableClientId, 11));
        boolean result = resp.getResultBoolean();
        return result;
    }

    @Override
    public CacheInfo setCacheLockTimeout(CacheInfo c, int v) throws AdminException {
        return this.setCacheConfigValue(c, 1, v);
    }

    @Override
    public CacheInfo setCacheLockLease(CacheInfo c, int v) throws AdminException {
        return this.setCacheConfigValue(c, 2, v);
    }

    @Override
    public CacheInfo setCacheSearchTimeout(CacheInfo c, int v) throws AdminException {
        return this.setCacheConfigValue(c, 3, v);
    }

    @Override
    public AdminBridgeServer addCacheServer(CacheInfo cache) throws AdminException {
        BridgeServerRequest request = BridgeServerRequest.createForAdd(cache);
        BridgeServerResponse response = (BridgeServerResponse)this.sendAndWait(request);
        if (response.getException() != null) {
            Exception ex = response.getException();
            throw new AdminException(ex.getMessage(), ex);
        }
        return response.getBridgeInfo();
    }

    @Override
    public AdminBridgeServer getBridgeInfo(CacheInfo cache, int bridgeRef) throws AdminException {
        BridgeServerRequest request = BridgeServerRequest.createForInfo(cache, bridgeRef);
        BridgeServerResponse response = (BridgeServerResponse)this.sendAndWait(request);
        if (response.getException() != null) {
            Exception ex = response.getException();
            throw new AdminException(ex.getMessage(), ex);
        }
        return response.getBridgeInfo();
    }

    @Override
    public AdminBridgeServer startBridgeServer(CacheInfo cache, AdminBridgeServer bridge) throws AdminException {
        BridgeServerRequest request = BridgeServerRequest.createForStart(cache, (RemoteBridgeServer)bridge);
        BridgeServerResponse response = (BridgeServerResponse)this.sendAndWait(request);
        if (response.getException() != null) {
            Exception ex = response.getException();
            throw new AdminException(ex.getMessage(), ex);
        }
        return response.getBridgeInfo();
    }

    @Override
    public AdminBridgeServer stopBridgeServer(CacheInfo cache, AdminBridgeServer bridge) throws AdminException {
        BridgeServerRequest request = BridgeServerRequest.createForStop(cache, (RemoteBridgeServer)bridge);
        BridgeServerResponse response = (BridgeServerResponse)this.sendAndWait(request);
        if (response.getException() != null) {
            Exception ex = response.getException();
            throw new AdminException(ex.getMessage(), ex);
        }
        return response.getBridgeInfo();
    }

    private CacheInfo setCacheConfigValue(CacheInfo c, int opCode, int value) throws AdminException {
        if (c.isClosed()) {
            return c;
        }
        CacheConfigResponse resp = (CacheConfigResponse)this.sendAndWait(CacheConfigRequest.create(c, opCode, value));
        if (resp.getException() != null) {
            Exception ex = resp.getException();
            throw new AdminException(ex.getMessage(), ex);
        }
        if (resp.getCacheInfo() == null) {
            c.setClosed();
            return c;
        }
        return resp.getCacheInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopStatListening() {
        Object object = this.statListenersLock;
        synchronized (object) {
            this.statListeners = new ListenerIdMap();
            this.unreachable = true;
        }
        this.dispatcher.stopDispatching();
    }

    public void disconnect(boolean alertListenerRegistered) {
        try {
            AdminConsoleDisconnectMessage msg = AdminConsoleDisconnectMessage.create();
            msg.setAlertListenerExpected(alertListenerRegistered);
            msg.setCrashed(false);
            this.sendAsync(msg);
        }
        finally {
            this.stopStatListening();
        }
    }

    @Override
    public void setInspectionClasspath(String classpath) {
        this.inspectionClasspath = classpath;
    }

    @Override
    public String getInspectionClasspath() {
        return this.inspectionClasspath;
    }

    AdminResponse sendAndWait(AdminRequest msg) {
        if (this.unreachable) {
            throw new OperationCancelledException(LocalizedStrings.RemoteGemFireVM_0_IS_UNREACHABLE_IT_HAS_EITHER_LEFT_OR_CRASHED.toLocalizedString(this.name));
        }
        if (this.id == null) {
            throw new NullPointerException(LocalizedStrings.RemoteGemFireVM_THE_ID_IF_THIS_REMOTEGEMFIREVM_IS_NULL.toLocalizedString());
        }
        msg.setRecipient(this.id);
        msg.setModifiedClasspath(this.inspectionClasspath);
        return this.agent.sendAndWait(msg);
    }

    void sendAsync(DistributionMessage msg) {
        msg.setRecipient(this.id);
        if (msg instanceof AdminRequest) {
            ((AdminRequest)msg).setModifiedClasspath(this.inspectionClasspath);
        }
        this.agent.sendAsync(msg);
    }

    @Override
    public void setAlertsManager(StatAlertDefinition[] alertDefs, long refreshInterval, boolean setRemotely) {
        if (setRemotely) {
            this.sendAsync(StatAlertsManagerAssignMessage.create(alertDefs, refreshInterval));
        }
    }

    @Override
    public void setRefreshInterval(long refreshInterval) {
        this.sendAsync(ChangeRefreshIntervalMessage.create(refreshInterval));
    }

    @Override
    public void updateAlertDefinitions(StatAlertDefinition[] alertDefs, int actionCode) {
        this.sendAsync(UpdateAlertDefinitionMessage.create(alertDefs, actionCode));
    }

    private static class DispatchArgs {
        protected final long timestamp;
        protected final int[] listenerIds;
        protected final double[] values;

        protected DispatchArgs(long timestamp, int[] listenerIds, double[] values) {
            this.timestamp = timestamp;
            this.listenerIds = listenerIds;
            this.values = values;
        }
    }

    private class StatDispatcher
    extends Thread {
        private BlockingQueue queue;
        private volatile boolean stopped;

        protected StatDispatcher() {
            super(RemoteGemFireVM.this.agent.getThreadGroup(), "StatDispatcher");
            this.queue = new LinkedBlockingQueue();
            this.stopped = false;
            this.setDaemon(true);
        }

        protected synchronized void stopDispatching() {
            this.stopped = true;
            this.interrupt();
        }

        @Override
        public void run() {
            while (!this.stopped) {
                SystemFailure.checkFailure();
                try {
                    DispatchArgs args = (DispatchArgs)this.queue.take();
                    RemoteGemFireVM.this.internalCallStatListeners(args.timestamp, args.listenerIds, args.values);
                }
                catch (InterruptedException ex) {
                    break;
                }
                catch (Exception exception) {
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void put(DispatchArgs args) {
            while (true) {
                RemoteGemFireVM.this.agent.getDM().getCancelCriterion().checkCancelInProgress(null);
                boolean interrupted = Thread.interrupted();
                try {
                    this.queue.put(args);
                }
                catch (InterruptedException ignore) {
                    interrupted = true;
                    continue;
                }
                finally {
                    if (!interrupted) continue;
                    Thread.currentThread().interrupt();
                    continue;
                }
                break;
            }
        }
    }
}

