/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.internal.admin.CacheInfo;
import org.apache.geode.internal.admin.remote.AdminRequest;
import org.apache.geode.internal.admin.remote.AdminResponse;
import org.apache.geode.internal.admin.remote.RegionResponse;
import org.apache.geode.internal.admin.remote.RemoteRegionAttributes;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class RegionRequest
extends AdminRequest {
    static final int GET_REGION = 10;
    static final int CREATE_VM_ROOT = 11;
    static final int CREATE_VM_REGION = 12;
    int action = 0;
    int cacheId = 0;
    String path;
    String newRegionName;
    RegionAttributes newRegionAttributes;

    public static RegionRequest createForGet(CacheInfo c, String path) {
        RegionRequest m = new RegionRequest();
        m.action = 10;
        m.cacheId = c.getId();
        m.path = path;
        RegionRequest.setFriendlyName(m);
        return m;
    }

    public static RegionRequest createForCreateRoot(CacheInfo c, String name, RegionAttributes attrs) {
        RegionRequest m = new RegionRequest();
        m.action = 11;
        m.cacheId = c.getId();
        m.newRegionName = name;
        m.newRegionAttributes = new RemoteRegionAttributes(attrs);
        RegionRequest.setFriendlyName(m);
        return m;
    }

    public static RegionRequest createForCreateSubregion(CacheInfo c, String parentPath, String name, RegionAttributes attrs) {
        RegionRequest m = new RegionRequest();
        m.action = 12;
        m.cacheId = c.getId();
        m.path = parentPath;
        m.newRegionName = name;
        m.newRegionAttributes = new RemoteRegionAttributes(attrs);
        RegionRequest.setFriendlyName(m);
        return m;
    }

    public RegionRequest() {
        RegionRequest.setFriendlyName(this);
    }

    @Override
    protected AdminResponse createResponse(DistributionManager dm) {
        return RegionResponse.create(dm, this.getSender(), this);
    }

    @Override
    public int getDSFID() {
        return 1043;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.action);
        out.writeInt(this.cacheId);
        DataSerializer.writeString(this.path, out);
        DataSerializer.writeString(this.newRegionName, out);
        DataSerializer.writeObject(this.newRegionAttributes, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.action = in.readInt();
        this.cacheId = in.readInt();
        this.path = DataSerializer.readString(in);
        this.newRegionName = DataSerializer.readString(in);
        this.newRegionAttributes = (RegionAttributes)DataSerializer.readObject(in);
        RegionRequest.setFriendlyName(this);
    }

    @Override
    public String toString() {
        return "RegionRequest from " + this.getRecipient() + " path=" + this.path;
    }

    private static void setFriendlyName(RegionRequest rgnRqst) {
        switch (rgnRqst.action) {
            case 10: {
                rgnRqst.friendlyName = LocalizedStrings.RegionRequest_GET_A_SPECIFIC_REGION_FROM_THE_ROOT.toLocalizedString();
                break;
            }
            case 11: {
                rgnRqst.friendlyName = LocalizedStrings.RegionRequest_CREATE_A_NEW_ROOT_VM_REGION.toLocalizedString();
                break;
            }
            case 12: {
                rgnRqst.friendlyName = LocalizedStrings.RegionRequest_CREATE_A_NEW_VM_REGION.toLocalizedString();
                break;
            }
            default: {
                rgnRqst.friendlyName = LocalizedStrings.RegionRequest_UNKNOWN_OPERATION_0.toLocalizedString(rgnRqst.action);
            }
        }
    }
}

