/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.admin.RuntimeAdminException;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.PooledDistributionMessage;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.admin.remote.AdminFailureResponse;
import org.apache.geode.internal.admin.remote.AdminReplyProcessor;
import org.apache.geode.internal.admin.remote.AdminResponse;
import org.apache.geode.internal.admin.remote.AdminWaiters;
import org.apache.geode.internal.admin.remote.InspectionClasspathManager;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public abstract class AdminRequest
extends PooledDistributionMessage {
    private static final Logger logger = LogService.getLogger();
    private String modifiedClasspath = "";
    protected transient String friendlyName = "";
    private transient AdminReplyProcessor processor;
    protected int msgId;

    public int getMsgId() {
        return this.msgId;
    }

    public AdminResponse sendAndWait(ClusterDistributionManager dm) {
        InternalDistributedMember recipient = this.getRecipient();
        if (dm.getId().equals(recipient)) {
            this.msgId = -1;
        } else {
            this.processor = new AdminReplyProcessor(dm.getSystem(), recipient);
            this.msgId = this.processor.getProcessorId();
        }
        return AdminWaiters.sendAndWait(this, dm);
    }

    boolean waitForResponse(long timeout) throws InterruptedException {
        try {
            return this.processor.waitForReplies(timeout);
        }
        catch (ReplyException ex) {
            for (Throwable cause = ex.getCause(); cause != null; cause = cause.getCause()) {
                if (!(cause instanceof RuntimeAdminException)) continue;
                throw (RuntimeAdminException)cause;
            }
            throw new RuntimeAdminException(LocalizedStrings.AdminRequest_A_REPLYEXCEPTION_WAS_THROWN_WHILE_WAITING_FOR_A_REPLY.toLocalizedString(), ex);
        }
    }

    AdminResponse getResponse() {
        return this.processor.getResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(ClusterDistributionManager dm) {
        AdminResponse response = null;
        InspectionClasspathManager cpMgr = InspectionClasspathManager.getInstance();
        try {
            cpMgr.jumpToModifiedClassLoader(this.modifiedClasspath);
            response = this.createResponse(dm);
        }
        catch (Exception ex) {
            response = AdminFailureResponse.create(this.getSender(), ex);
        }
        finally {
            cpMgr.revertToOldClassLoader();
        }
        if (response != null) {
            response.setMsgId(this.getMsgId());
            dm.putOutgoing(response);
        } else {
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.AdminRequest_RESPONSE_TO__0__WAS_CANCELLED, this.getClass().getName()));
        }
    }

    protected abstract AdminResponse createResponse(DistributionManager var1);

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.msgId);
        DataSerializer.writeString(this.modifiedClasspath, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.msgId = in.readInt();
        this.modifiedClasspath = DataSerializer.readString(in);
    }

    public void setModifiedClasspath(String path) {
        this.modifiedClasspath = path == null ? "" : path;
    }

    public InternalDistributedMember getRecipient() {
        InternalDistributedMember[] recipients = this.getRecipients();
        int size = recipients.length;
        if (size == 0) {
            return null;
        }
        if (size > 1) {
            throw new IllegalStateException(LocalizedStrings.AdminRequest_COULD_NOT_RETURN_ONE_RECIPIENT_BECAUSE_THIS_MESSAGE_HAS_0_RECIPIENTS.toLocalizedString(size));
        }
        return recipients[0];
    }
}

